package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StorageClassAnalysisDataExport(
    outputSchemaVersion: zio.aws.s3.model.StorageClassAnalysisSchemaVersion,
    destination: zio.aws.s3.model.AnalyticsExportDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport = {
    import StorageClassAnalysisDataExport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
      .builder()
      .outputSchemaVersion(outputSchemaVersion.unwrap)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly =
    zio.aws.s3.model.StorageClassAnalysisDataExport.wrap(buildAwsValue())
}
object StorageClassAnalysisDataExport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.StorageClassAnalysisDataExport =
      zio.aws.s3.model.StorageClassAnalysisDataExport(
        outputSchemaVersion,
        destination.asEditable
      )
    def outputSchemaVersion: zio.aws.s3.model.StorageClassAnalysisSchemaVersion
    def destination: zio.aws.s3.model.AnalyticsExportDestination.ReadOnly
    def getOutputSchemaVersion: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.StorageClassAnalysisSchemaVersion
    ] = ZIO.succeed(outputSchemaVersion)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.AnalyticsExportDestination.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ) extends zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly {
    override val outputSchemaVersion
        : zio.aws.s3.model.StorageClassAnalysisSchemaVersion =
      zio.aws.s3.model.StorageClassAnalysisSchemaVersion
        .wrap(impl.outputSchemaVersion())
    override val destination
        : zio.aws.s3.model.AnalyticsExportDestination.ReadOnly =
      zio.aws.s3.model.AnalyticsExportDestination.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ): zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly = new Wrapper(
    impl
  )
}
