package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetGrant(
    grantee: Optional[zio.aws.s3.model.Grantee] = Optional.Absent,
    permission: Optional[zio.aws.s3.model.BucketLogsPermission] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.TargetGrant = {
    import TargetGrant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.TargetGrant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.TargetGrant.ReadOnly =
    zio.aws.s3.model.TargetGrant.wrap(buildAwsValue())
}
object TargetGrant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.TargetGrant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.TargetGrant = zio.aws.s3.model.TargetGrant(
      grantee.map(value => value.asEditable),
      permission.map(value => value)
    )
    def grantee: Optional[zio.aws.s3.model.Grantee.ReadOnly]
    def permission: Optional[zio.aws.s3.model.BucketLogsPermission]
    def getGrantee: ZIO[Any, AwsError, zio.aws.s3.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getPermission
        : ZIO[Any, AwsError, zio.aws.s3.model.BucketLogsPermission] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.TargetGrant
  ) extends zio.aws.s3.model.TargetGrant.ReadOnly {
    override val grantee: Optional[zio.aws.s3.model.Grantee.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantee())
        .map(value => zio.aws.s3.model.Grantee.wrap(value))
    override val permission: Optional[zio.aws.s3.model.BucketLogsPermission] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permission())
        .map(value => zio.aws.s3.model.BucketLogsPermission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.TargetGrant
  ): zio.aws.s3.model.TargetGrant.ReadOnly = new Wrapper(impl)
}
