package zio.aws.s3.model
import zio.aws.s3.model.primitives.{TopicArn, NotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TopicConfiguration(
    id: Optional[NotificationId] = Optional.Absent,
    topicArn: TopicArn,
    events: Iterable[zio.aws.s3.model.Event],
    filter: Optional[zio.aws.s3.model.NotificationConfigurationFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.TopicConfiguration = {
    import TopicConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.TopicConfiguration
      .builder()
      .optionallyWith(
        id.map(value => NotificationId.unwrap(value): java.lang.String)
      )(_.id)
      .topicArn(TopicArn.unwrap(topicArn): java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.TopicConfiguration.ReadOnly =
    zio.aws.s3.model.TopicConfiguration.wrap(buildAwsValue())
}
object TopicConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.TopicConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.TopicConfiguration =
      zio.aws.s3.model.TopicConfiguration(
        id.map(value => value),
        topicArn,
        events,
        filter.map(value => value.asEditable)
      )
    def id: Optional[NotificationId]
    def topicArn: TopicArn
    def events: List[zio.aws.s3.model.Event]
    def filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", id)
    def getTopicArn: ZIO[Any, Nothing, TopicArn] = ZIO.succeed(topicArn)
    def getEvents: ZIO[Any, Nothing, List[zio.aws.s3.model.Event]] =
      ZIO.succeed(events)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.TopicConfiguration
  ) extends zio.aws.s3.model.TopicConfiguration.ReadOnly {
    override val id: Optional[NotificationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.NotificationId(value))
    override val topicArn: TopicArn =
      zio.aws.s3.model.primitives.TopicArn(impl.topicArn())
    override val events: List[zio.aws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.s3.model.Event.wrap(item)
      }
      .toList
    override val filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.s3.model.NotificationConfigurationFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.TopicConfiguration
  ): zio.aws.s3.model.TopicConfiguration.ReadOnly = new Wrapper(impl)
}
