package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait TransitionStorageClass {
  def unwrap: software.amazon.awssdk.services.s3.model.TransitionStorageClass
}
object TransitionStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.TransitionStorageClass
  ): zio.aws.s3.model.TransitionStorageClass = value match {
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.s3.model.TransitionStorageClass.GLACIER_IR =>
      val r = GLACIER_IR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object GLACIER extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.GLACIER
  }
  case object STANDARD_IA extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.STANDARD_IA
  }
  case object ONEZONE_IA extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.INTELLIGENT_TIERING
  }
  case object DEEP_ARCHIVE extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.DEEP_ARCHIVE
  }
  case object GLACIER_IR extends zio.aws.s3.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3.model.TransitionStorageClass.GLACIER_IR
  }
}
