package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WebsiteConfiguration(
    errorDocument: Optional[zio.aws.s3.model.ErrorDocument] = Optional.Absent,
    indexDocument: Optional[zio.aws.s3.model.IndexDocument] = Optional.Absent,
    redirectAllRequestsTo: Optional[zio.aws.s3.model.RedirectAllRequestsTo] =
      Optional.Absent,
    routingRules: Optional[Iterable[zio.aws.s3.model.RoutingRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WebsiteConfiguration = {
    import WebsiteConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
      .builder()
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.WebsiteConfiguration.ReadOnly =
    zio.aws.s3.model.WebsiteConfiguration.wrap(buildAwsValue())
}
object WebsiteConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.WebsiteConfiguration =
      zio.aws.s3.model.WebsiteConfiguration(
        errorDocument.map(value => value.asEditable),
        indexDocument.map(value => value.asEditable),
        redirectAllRequestsTo.map(value => value.asEditable),
        routingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errorDocument: Optional[zio.aws.s3.model.ErrorDocument.ReadOnly]
    def indexDocument: Optional[zio.aws.s3.model.IndexDocument.ReadOnly]
    def redirectAllRequestsTo
        : Optional[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def routingRules: Optional[List[zio.aws.s3.model.RoutingRule.ReadOnly]]
    def getErrorDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.ErrorDocument.ReadOnly] =
      AwsError.unwrapOptionField("errorDocument", errorDocument)
    def getIndexDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.IndexDocument.ReadOnly] =
      AwsError.unwrapOptionField("indexDocument", indexDocument)
    def getRedirectAllRequestsTo
        : ZIO[Any, AwsError, zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      AwsError.unwrapOptionField("redirectAllRequestsTo", redirectAllRequestsTo)
    def getRoutingRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      AwsError.unwrapOptionField("routingRules", routingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ) extends zio.aws.s3.model.WebsiteConfiguration.ReadOnly {
    override val errorDocument
        : Optional[zio.aws.s3.model.ErrorDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDocument())
        .map(value => zio.aws.s3.model.ErrorDocument.wrap(value))
    override val indexDocument
        : Optional[zio.aws.s3.model.IndexDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexDocument())
        .map(value => zio.aws.s3.model.IndexDocument.wrap(value))
    override val redirectAllRequestsTo
        : Optional[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redirectAllRequestsTo())
        .map(value => zio.aws.s3.model.RedirectAllRequestsTo.wrap(value))
    override val routingRules
        : Optional[List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.RoutingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ): zio.aws.s3.model.WebsiteConfiguration.ReadOnly = new Wrapper(impl)
}
