package zio.aws.s3
import zio.prelude.Subtype
import zio.aws.s3.model.primitives.{
  AllowedOrigin,
  AllowedMethod,
  AllowedHeader,
  ExposeHeader,
  MetadataValue,
  MetadataKey
}
import zio.Chunk
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AbortDate extends Subtype[Instant]
    type AbortDate = zio.aws.s3.model.primitives.AbortDate.Type
    object AbortRuleId extends Subtype[String]
    type AbortRuleId = zio.aws.s3.model.primitives.AbortRuleId.Type
    object AcceptRanges extends Subtype[String]
    type AcceptRanges = zio.aws.s3.model.primitives.AcceptRanges.Type
    object AccessPointArn extends Subtype[String]
    type AccessPointArn = zio.aws.s3.model.primitives.AccessPointArn.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.s3.model.primitives.AccountId.Type
    object AllowQuotedRecordDelimiter extends Subtype[Boolean]
    type AllowQuotedRecordDelimiter =
      zio.aws.s3.model.primitives.AllowQuotedRecordDelimiter.Type
    object AllowedHeader extends Subtype[String]
    type AllowedHeader = zio.aws.s3.model.primitives.AllowedHeader.Type
    object AllowedMethod extends Subtype[String]
    type AllowedMethod = zio.aws.s3.model.primitives.AllowedMethod.Type
    object AllowedOrigin extends Subtype[String]
    type AllowedOrigin = zio.aws.s3.model.primitives.AllowedOrigin.Type
    object AnalyticsId extends Subtype[String]
    type AnalyticsId = zio.aws.s3.model.primitives.AnalyticsId.Type
    object Body extends Subtype[Chunk[Byte]]
    type Body = zio.aws.s3.model.primitives.Body.Type
    object BucketKeyEnabled extends Subtype[Boolean]
    type BucketKeyEnabled = zio.aws.s3.model.primitives.BucketKeyEnabled.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.s3.model.primitives.BucketName.Type
    object BypassGovernanceRetention extends Subtype[Boolean]
    type BypassGovernanceRetention =
      zio.aws.s3.model.primitives.BypassGovernanceRetention.Type
    object CacheControl extends Subtype[String]
    type CacheControl = zio.aws.s3.model.primitives.CacheControl.Type
    object ChecksumCRC32 extends Subtype[String]
    type ChecksumCRC32 = zio.aws.s3.model.primitives.ChecksumCRC32.Type
    object ChecksumCRC32C extends Subtype[String]
    type ChecksumCRC32C = zio.aws.s3.model.primitives.ChecksumCRC32C.Type
    object ChecksumSHA1 extends Subtype[String]
    type ChecksumSHA1 = zio.aws.s3.model.primitives.ChecksumSHA1.Type
    object ChecksumSHA256 extends Subtype[String]
    type ChecksumSHA256 = zio.aws.s3.model.primitives.ChecksumSHA256.Type
    object Code extends Subtype[String]
    type Code = zio.aws.s3.model.primitives.Code.Type
    object Comments extends Subtype[String]
    type Comments = zio.aws.s3.model.primitives.Comments.Type
    object ConfirmRemoveSelfBucketAccess extends Subtype[Boolean]
    type ConfirmRemoveSelfBucketAccess =
      zio.aws.s3.model.primitives.ConfirmRemoveSelfBucketAccess.Type
    object ContentDisposition extends Subtype[String]
    type ContentDisposition =
      zio.aws.s3.model.primitives.ContentDisposition.Type
    object ContentEncoding extends Subtype[String]
    type ContentEncoding = zio.aws.s3.model.primitives.ContentEncoding.Type
    object ContentLanguage extends Subtype[String]
    type ContentLanguage = zio.aws.s3.model.primitives.ContentLanguage.Type
    object ContentLength extends Subtype[Long]
    type ContentLength = zio.aws.s3.model.primitives.ContentLength.Type
    object ContentMD5 extends Subtype[String]
    type ContentMD5 = zio.aws.s3.model.primitives.ContentMD5.Type
    object ContentRange extends Subtype[String]
    type ContentRange = zio.aws.s3.model.primitives.ContentRange.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.s3.model.primitives.ContentType.Type
    object CopySource extends Subtype[String]
    type CopySource = zio.aws.s3.model.primitives.CopySource.Type
    object CopySourceIfMatch extends Subtype[String]
    type CopySourceIfMatch = zio.aws.s3.model.primitives.CopySourceIfMatch.Type
    object CopySourceIfModifiedSince extends Subtype[Instant]
    type CopySourceIfModifiedSince =
      zio.aws.s3.model.primitives.CopySourceIfModifiedSince.Type
    object CopySourceIfNoneMatch extends Subtype[String]
    type CopySourceIfNoneMatch =
      zio.aws.s3.model.primitives.CopySourceIfNoneMatch.Type
    object CopySourceIfUnmodifiedSince extends Subtype[Instant]
    type CopySourceIfUnmodifiedSince =
      zio.aws.s3.model.primitives.CopySourceIfUnmodifiedSince.Type
    object CopySourceRange extends Subtype[String]
    type CopySourceRange = zio.aws.s3.model.primitives.CopySourceRange.Type
    object CopySourceSSECustomerAlgorithm extends Subtype[String]
    type CopySourceSSECustomerAlgorithm =
      zio.aws.s3.model.primitives.CopySourceSSECustomerAlgorithm.Type
    object CopySourceSSECustomerKey extends Subtype[String]
    type CopySourceSSECustomerKey =
      zio.aws.s3.model.primitives.CopySourceSSECustomerKey.Type
    object CopySourceSSECustomerKeyMD5 extends Subtype[String]
    type CopySourceSSECustomerKeyMD5 =
      zio.aws.s3.model.primitives.CopySourceSSECustomerKeyMD5.Type
    object CopySourceVersionId extends Subtype[String]
    type CopySourceVersionId =
      zio.aws.s3.model.primitives.CopySourceVersionId.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.s3.model.primitives.CreationDate.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.s3.model.primitives.Date.Type
    object Days extends Subtype[Int]
    type Days = zio.aws.s3.model.primitives.Days.Type
    object DaysAfterInitiation extends Subtype[Int]
    type DaysAfterInitiation =
      zio.aws.s3.model.primitives.DaysAfterInitiation.Type
    object DeleteMarker extends Subtype[Boolean]
    type DeleteMarker = zio.aws.s3.model.primitives.DeleteMarker.Type
    object DeleteMarkerVersionId extends Subtype[String]
    type DeleteMarkerVersionId =
      zio.aws.s3.model.primitives.DeleteMarkerVersionId.Type
    object Delimiter extends Subtype[String]
    type Delimiter = zio.aws.s3.model.primitives.Delimiter.Type
    object Description extends Subtype[String]
    type Description = zio.aws.s3.model.primitives.Description.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.s3.model.primitives.DisplayName.Type
    object ETag extends Subtype[String]
    type ETag = zio.aws.s3.model.primitives.ETag.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.s3.model.primitives.EmailAddress.Type
    object EnableRequestProgress extends Subtype[Boolean]
    type EnableRequestProgress =
      zio.aws.s3.model.primitives.EnableRequestProgress.Type
    object End extends Subtype[Long]
    type End = zio.aws.s3.model.primitives.End.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.s3.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.s3.model.primitives.ErrorMessage.Type
    object Expiration extends Subtype[String]
    type Expiration = zio.aws.s3.model.primitives.Expiration.Type
    object ExpiredObjectDeleteMarker extends Subtype[Boolean]
    type ExpiredObjectDeleteMarker =
      zio.aws.s3.model.primitives.ExpiredObjectDeleteMarker.Type
    object Expires extends Subtype[Instant]
    type Expires = zio.aws.s3.model.primitives.Expires.Type
    object ExposeHeader extends Subtype[String]
    type ExposeHeader = zio.aws.s3.model.primitives.ExposeHeader.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.s3.model.primitives.Expression.Type
    object FetchOwner extends Subtype[Boolean]
    type FetchOwner = zio.aws.s3.model.primitives.FetchOwner.Type
    object FieldDelimiter extends Subtype[String]
    type FieldDelimiter = zio.aws.s3.model.primitives.FieldDelimiter.Type
    object FilterRuleValue extends Subtype[String]
    type FilterRuleValue = zio.aws.s3.model.primitives.FilterRuleValue.Type
    object GetObjectResponseStatusCode extends Subtype[Int]
    type GetObjectResponseStatusCode =
      zio.aws.s3.model.primitives.GetObjectResponseStatusCode.Type
    object GrantFullControl extends Subtype[String]
    type GrantFullControl = zio.aws.s3.model.primitives.GrantFullControl.Type
    object GrantRead extends Subtype[String]
    type GrantRead = zio.aws.s3.model.primitives.GrantRead.Type
    object GrantReadACP extends Subtype[String]
    type GrantReadACP = zio.aws.s3.model.primitives.GrantReadACP.Type
    object GrantWrite extends Subtype[String]
    type GrantWrite = zio.aws.s3.model.primitives.GrantWrite.Type
    object GrantWriteACP extends Subtype[String]
    type GrantWriteACP = zio.aws.s3.model.primitives.GrantWriteACP.Type
    object HostName extends Subtype[String]
    type HostName = zio.aws.s3.model.primitives.HostName.Type
    object HttpErrorCodeReturnedEquals extends Subtype[String]
    type HttpErrorCodeReturnedEquals =
      zio.aws.s3.model.primitives.HttpErrorCodeReturnedEquals.Type
    object HttpRedirectCode extends Subtype[String]
    type HttpRedirectCode = zio.aws.s3.model.primitives.HttpRedirectCode.Type
    object ID extends Subtype[String]
    type ID = zio.aws.s3.model.primitives.ID.Type
    object IfMatch extends Subtype[String]
    type IfMatch = zio.aws.s3.model.primitives.IfMatch.Type
    object IfModifiedSince extends Subtype[Instant]
    type IfModifiedSince = zio.aws.s3.model.primitives.IfModifiedSince.Type
    object IfNoneMatch extends Subtype[String]
    type IfNoneMatch = zio.aws.s3.model.primitives.IfNoneMatch.Type
    object IfUnmodifiedSince extends Subtype[Instant]
    type IfUnmodifiedSince = zio.aws.s3.model.primitives.IfUnmodifiedSince.Type
    object Initiated extends Subtype[Instant]
    type Initiated = zio.aws.s3.model.primitives.Initiated.Type
    object IntelligentTieringDays extends Subtype[Int]
    type IntelligentTieringDays =
      zio.aws.s3.model.primitives.IntelligentTieringDays.Type
    object IntelligentTieringId extends Subtype[String]
    type IntelligentTieringId =
      zio.aws.s3.model.primitives.IntelligentTieringId.Type
    object InventoryId extends Subtype[String]
    type InventoryId = zio.aws.s3.model.primitives.InventoryId.Type
    object IsEnabled extends Subtype[Boolean]
    type IsEnabled = zio.aws.s3.model.primitives.IsEnabled.Type
    object IsLatest extends Subtype[Boolean]
    type IsLatest = zio.aws.s3.model.primitives.IsLatest.Type
    object IsPublic extends Subtype[Boolean]
    type IsPublic = zio.aws.s3.model.primitives.IsPublic.Type
    object IsRestoreInProgress extends Subtype[Boolean]
    type IsRestoreInProgress =
      zio.aws.s3.model.primitives.IsRestoreInProgress.Type
    object IsTruncated extends Subtype[Boolean]
    type IsTruncated = zio.aws.s3.model.primitives.IsTruncated.Type
    object KMSContext extends Subtype[String]
    type KMSContext = zio.aws.s3.model.primitives.KMSContext.Type
    object KeyCount extends Subtype[Int]
    type KeyCount = zio.aws.s3.model.primitives.KeyCount.Type
    object KeyMarker extends Subtype[String]
    type KeyMarker = zio.aws.s3.model.primitives.KeyMarker.Type
    object KeyPrefixEquals extends Subtype[String]
    type KeyPrefixEquals = zio.aws.s3.model.primitives.KeyPrefixEquals.Type
    object LambdaFunctionArn extends Subtype[String]
    type LambdaFunctionArn = zio.aws.s3.model.primitives.LambdaFunctionArn.Type
    object LastModified extends Subtype[Instant]
    type LastModified = zio.aws.s3.model.primitives.LastModified.Type
    object Location extends Subtype[String]
    type Location = zio.aws.s3.model.primitives.Location.Type
    object LocationPrefix extends Subtype[String]
    type LocationPrefix = zio.aws.s3.model.primitives.LocationPrefix.Type
    object MFA extends Subtype[String]
    type MFA = zio.aws.s3.model.primitives.MFA.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.s3.model.primitives.Marker.Type
    object MaxAgeSeconds extends Subtype[Int]
    type MaxAgeSeconds = zio.aws.s3.model.primitives.MaxAgeSeconds.Type
    object MaxKeys extends Subtype[Int]
    type MaxKeys = zio.aws.s3.model.primitives.MaxKeys.Type
    object MaxParts extends Subtype[Int]
    type MaxParts = zio.aws.s3.model.primitives.MaxParts.Type
    object MaxUploads extends Subtype[Int]
    type MaxUploads = zio.aws.s3.model.primitives.MaxUploads.Type
    object Message extends Subtype[String]
    type Message = zio.aws.s3.model.primitives.Message.Type
    object MetadataKey extends Subtype[String]
    type MetadataKey = zio.aws.s3.model.primitives.MetadataKey.Type
    object MetadataValue extends Subtype[String]
    type MetadataValue = zio.aws.s3.model.primitives.MetadataValue.Type
    object MetricsId extends Subtype[String]
    type MetricsId = zio.aws.s3.model.primitives.MetricsId.Type
    object Minutes extends Subtype[Int]
    type Minutes = zio.aws.s3.model.primitives.Minutes.Type
    object MissingMeta extends Subtype[Int]
    type MissingMeta = zio.aws.s3.model.primitives.MissingMeta.Type
    object MultipartUploadId extends Subtype[String]
    type MultipartUploadId = zio.aws.s3.model.primitives.MultipartUploadId.Type
    object NextKeyMarker extends Subtype[String]
    type NextKeyMarker = zio.aws.s3.model.primitives.NextKeyMarker.Type
    object NextMarker extends Subtype[String]
    type NextMarker = zio.aws.s3.model.primitives.NextMarker.Type
    object NextPartNumberMarker extends Subtype[Int]
    type NextPartNumberMarker =
      zio.aws.s3.model.primitives.NextPartNumberMarker.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.s3.model.primitives.NextToken.Type
    object NextUploadIdMarker extends Subtype[String]
    type NextUploadIdMarker =
      zio.aws.s3.model.primitives.NextUploadIdMarker.Type
    object NextVersionIdMarker extends Subtype[String]
    type NextVersionIdMarker =
      zio.aws.s3.model.primitives.NextVersionIdMarker.Type
    object NotificationId extends Subtype[String]
    type NotificationId = zio.aws.s3.model.primitives.NotificationId.Type
    object ObjectKey extends Subtype[String]
    type ObjectKey = zio.aws.s3.model.primitives.ObjectKey.Type
    object ObjectLockEnabledForBucket extends Subtype[Boolean]
    type ObjectLockEnabledForBucket =
      zio.aws.s3.model.primitives.ObjectLockEnabledForBucket.Type
    object ObjectLockRetainUntilDate extends Subtype[Instant]
    type ObjectLockRetainUntilDate =
      zio.aws.s3.model.primitives.ObjectLockRetainUntilDate.Type
    object ObjectLockToken extends Subtype[String]
    type ObjectLockToken = zio.aws.s3.model.primitives.ObjectLockToken.Type
    object ObjectSize extends Subtype[Long]
    type ObjectSize = zio.aws.s3.model.primitives.ObjectSize.Type
    object ObjectSizeGreaterThanBytes extends Subtype[Long]
    type ObjectSizeGreaterThanBytes =
      zio.aws.s3.model.primitives.ObjectSizeGreaterThanBytes.Type
    object ObjectSizeLessThanBytes extends Subtype[Long]
    type ObjectSizeLessThanBytes =
      zio.aws.s3.model.primitives.ObjectSizeLessThanBytes.Type
    object ObjectVersionId extends Subtype[String]
    type ObjectVersionId = zio.aws.s3.model.primitives.ObjectVersionId.Type
    object PartNumber extends Subtype[Int]
    type PartNumber = zio.aws.s3.model.primitives.PartNumber.Type
    object PartNumberMarker extends Subtype[Int]
    type PartNumberMarker = zio.aws.s3.model.primitives.PartNumberMarker.Type
    object PartsCount extends Subtype[Int]
    type PartsCount = zio.aws.s3.model.primitives.PartsCount.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.s3.model.primitives.Policy.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.s3.model.primitives.Prefix.Type
    object Priority extends Subtype[Int]
    type Priority = zio.aws.s3.model.primitives.Priority.Type
    object QueueArn extends Subtype[String]
    type QueueArn = zio.aws.s3.model.primitives.QueueArn.Type
    object Quiet extends Subtype[Boolean]
    type Quiet = zio.aws.s3.model.primitives.Quiet.Type
    object QuoteCharacter extends Subtype[String]
    type QuoteCharacter = zio.aws.s3.model.primitives.QuoteCharacter.Type
    object QuoteEscapeCharacter extends Subtype[String]
    type QuoteEscapeCharacter =
      zio.aws.s3.model.primitives.QuoteEscapeCharacter.Type
    object Range extends Subtype[String]
    type Range = zio.aws.s3.model.primitives.Range.Type
    object RecordDelimiter extends Subtype[String]
    type RecordDelimiter = zio.aws.s3.model.primitives.RecordDelimiter.Type
    object ReplaceKeyPrefixWith extends Subtype[String]
    type ReplaceKeyPrefixWith =
      zio.aws.s3.model.primitives.ReplaceKeyPrefixWith.Type
    object ReplaceKeyWith extends Subtype[String]
    type ReplaceKeyWith = zio.aws.s3.model.primitives.ReplaceKeyWith.Type
    object ReplicaKmsKeyID extends Subtype[String]
    type ReplicaKmsKeyID = zio.aws.s3.model.primitives.ReplicaKmsKeyID.Type
    object RequestRoute extends Subtype[String]
    type RequestRoute = zio.aws.s3.model.primitives.RequestRoute.Type
    object RequestToken extends Subtype[String]
    type RequestToken = zio.aws.s3.model.primitives.RequestToken.Type
    object ResponseCacheControl extends Subtype[String]
    type ResponseCacheControl =
      zio.aws.s3.model.primitives.ResponseCacheControl.Type
    object ResponseContentDisposition extends Subtype[String]
    type ResponseContentDisposition =
      zio.aws.s3.model.primitives.ResponseContentDisposition.Type
    object ResponseContentEncoding extends Subtype[String]
    type ResponseContentEncoding =
      zio.aws.s3.model.primitives.ResponseContentEncoding.Type
    object ResponseContentLanguage extends Subtype[String]
    type ResponseContentLanguage =
      zio.aws.s3.model.primitives.ResponseContentLanguage.Type
    object ResponseContentType extends Subtype[String]
    type ResponseContentType =
      zio.aws.s3.model.primitives.ResponseContentType.Type
    object ResponseExpires extends Subtype[Instant]
    type ResponseExpires = zio.aws.s3.model.primitives.ResponseExpires.Type
    object Restore extends Subtype[String]
    type Restore = zio.aws.s3.model.primitives.Restore.Type
    object RestoreExpiryDate extends Subtype[Instant]
    type RestoreExpiryDate = zio.aws.s3.model.primitives.RestoreExpiryDate.Type
    object RestoreOutputPath extends Subtype[String]
    type RestoreOutputPath = zio.aws.s3.model.primitives.RestoreOutputPath.Type
    object Role extends Subtype[String]
    type Role = zio.aws.s3.model.primitives.Role.Type
    object SSECustomerAlgorithm extends Subtype[String]
    type SSECustomerAlgorithm =
      zio.aws.s3.model.primitives.SSECustomerAlgorithm.Type
    object SSECustomerKey extends Subtype[String]
    type SSECustomerKey = zio.aws.s3.model.primitives.SSECustomerKey.Type
    object SSECustomerKeyMD5 extends Subtype[String]
    type SSECustomerKeyMD5 = zio.aws.s3.model.primitives.SSECustomerKeyMD5.Type
    object SSEKMSEncryptionContext extends Subtype[String]
    type SSEKMSEncryptionContext =
      zio.aws.s3.model.primitives.SSEKMSEncryptionContext.Type
    object SSEKMSKeyId extends Subtype[String]
    type SSEKMSKeyId = zio.aws.s3.model.primitives.SSEKMSKeyId.Type
    object Setting extends Subtype[Boolean]
    type Setting = zio.aws.s3.model.primitives.Setting.Type
    object Size extends Subtype[Long]
    type Size = zio.aws.s3.model.primitives.Size.Type
    object SkipValidation extends Subtype[Boolean]
    type SkipValidation = zio.aws.s3.model.primitives.SkipValidation.Type
    object Start extends Subtype[Long]
    type Start = zio.aws.s3.model.primitives.Start.Type
    object StartAfter extends Subtype[String]
    type StartAfter = zio.aws.s3.model.primitives.StartAfter.Type
    object Suffix extends Subtype[String]
    type Suffix = zio.aws.s3.model.primitives.Suffix.Type
    object TagCount extends Subtype[Int]
    type TagCount = zio.aws.s3.model.primitives.TagCount.Type
    object TaggingHeader extends Subtype[String]
    type TaggingHeader = zio.aws.s3.model.primitives.TaggingHeader.Type
    object TargetBucket extends Subtype[String]
    type TargetBucket = zio.aws.s3.model.primitives.TargetBucket.Type
    object TargetPrefix extends Subtype[String]
    type TargetPrefix = zio.aws.s3.model.primitives.TargetPrefix.Type
    object Token extends Subtype[String]
    type Token = zio.aws.s3.model.primitives.Token.Type
    object TopicArn extends Subtype[String]
    type TopicArn = zio.aws.s3.model.primitives.TopicArn.Type
    object URI extends Subtype[String]
    type URI = zio.aws.s3.model.primitives.URI.Type
    object UploadIdMarker extends Subtype[String]
    type UploadIdMarker = zio.aws.s3.model.primitives.UploadIdMarker.Type
    object Value extends Subtype[String]
    type Value = zio.aws.s3.model.primitives.Value.Type
    object VersionCount extends Subtype[Int]
    type VersionCount = zio.aws.s3.model.primitives.VersionCount.Type
    object VersionIdMarker extends Subtype[String]
    type VersionIdMarker = zio.aws.s3.model.primitives.VersionIdMarker.Type
    object WebsiteRedirectLocation extends Subtype[String]
    type WebsiteRedirectLocation =
      zio.aws.s3.model.primitives.WebsiteRedirectLocation.Type
    object Years extends Subtype[Int]
    type Years = zio.aws.s3.model.primitives.Years.Type
  }
  type AllowedHeaders = List[AllowedHeader]
  type AllowedMethods = List[AllowedMethod]
  type AllowedOrigins = List[AllowedOrigin]
  type AnalyticsConfigurationList =
    List[zio.aws.s3.model.AnalyticsConfiguration]
  type Buckets = List[zio.aws.s3.model.Bucket]
  type CORSRules = List[zio.aws.s3.model.CORSRule]
  type ChecksumAlgorithmList = List[zio.aws.s3.model.ChecksumAlgorithm]
  type CommonPrefixList = List[zio.aws.s3.model.CommonPrefix]
  type CompletedPartList = List[zio.aws.s3.model.CompletedPart]
  type DeleteMarkers = List[zio.aws.s3.model.DeleteMarkerEntry]
  type DeletedObjects = List[zio.aws.s3.model.DeletedObject]
  type Errors = List[zio.aws.s3.model.S3Error]
  type EventList = List[zio.aws.s3.model.Event]
  type ExposeHeaders = List[ExposeHeader]
  type FilterRuleList = List[zio.aws.s3.model.FilterRule]
  type Grants = List[zio.aws.s3.model.Grant]
  type IntelligentTieringConfigurationList =
    List[zio.aws.s3.model.IntelligentTieringConfiguration]
  type InventoryConfigurationList =
    List[zio.aws.s3.model.InventoryConfiguration]
  type InventoryOptionalFields = List[zio.aws.s3.model.InventoryOptionalField]
  type LambdaFunctionConfigurationList =
    List[zio.aws.s3.model.LambdaFunctionConfiguration]
  type LifecycleRules = List[zio.aws.s3.model.LifecycleRule]
  type Metadata = Map[MetadataKey, MetadataValue]
  type MetricsConfigurationList = List[zio.aws.s3.model.MetricsConfiguration]
  type MultipartUploadList = List[zio.aws.s3.model.MultipartUpload]
  type NoncurrentVersionTransitionList =
    List[zio.aws.s3.model.NoncurrentVersionTransition]
  type ObjectAttributesList = List[zio.aws.s3.model.ObjectAttributes]
  type ObjectIdentifierList = List[zio.aws.s3.model.ObjectIdentifier]
  type ObjectList = List[zio.aws.s3.model.S3Object]
  type ObjectVersionList = List[zio.aws.s3.model.ObjectVersion]
  type OptionalObjectAttributesList =
    List[zio.aws.s3.model.OptionalObjectAttributes]
  type OwnershipControlsRules = List[zio.aws.s3.model.OwnershipControlsRule]
  type Parts = List[zio.aws.s3.model.Part]
  type PartsList = List[zio.aws.s3.model.ObjectPart]
  type QueueConfigurationList = List[zio.aws.s3.model.QueueConfiguration]
  type ReplicationRules = List[zio.aws.s3.model.ReplicationRule]
  type RoutingRules = List[zio.aws.s3.model.RoutingRule]
  type ServerSideEncryptionRules =
    List[zio.aws.s3.model.ServerSideEncryptionRule]
  type TagSet = List[zio.aws.s3.model.Tag]
  type TargetGrants = List[zio.aws.s3.model.TargetGrant]
  type TieringList = List[zio.aws.s3.model.Tiering]
  type TopicConfigurationList = List[zio.aws.s3.model.TopicConfiguration]
  type TransitionList = List[zio.aws.s3.model.Transition]
  type UserMetadata = List[zio.aws.s3.model.MetadataEntry]
}
