package zio.aws.s3outposts
import zio.aws.s3outposts.model.ListEndpointsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.s3outposts.model.{
  ListEndpointsRequest,
  DeleteEndpointRequest,
  CreateEndpointRequest
}
import software.amazon.awssdk.services.s3outposts.{
  S3OutpostsAsyncClientBuilder,
  S3OutpostsAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.s3outposts.model.{
  DeleteEndpointResponse,
  ListEndpointsResponse,
  CreateEndpointResponse,
  Endpoint
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait S3Outposts extends AspectSupport[S3Outposts] {
  val api: S3OutpostsAsyncClient
  def createEndpoint(
      request: CreateEndpointRequest
  ): IO[AwsError, zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly]
  def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit]
  def listEndpoints(
      request: ListEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.s3outposts.model.Endpoint.ReadOnly]
  def listEndpointsPaginated(
      request: ListEndpointsRequest
  ): IO[AwsError, ReadOnly]
}
object S3Outposts {
  val live: ZLayer[AwsConfig, java.lang.Throwable, S3Outposts] = customized(
    identity
  )
  def customized(
      customization: S3OutpostsAsyncClientBuilder => S3OutpostsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, S3Outposts] = managed(
    customization
  ).toLayer
  def managed(
      customization: S3OutpostsAsyncClientBuilder => S3OutpostsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, S3Outposts] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = S3OutpostsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[S3OutpostsAsyncClient, S3OutpostsAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[S3OutpostsAsyncClient, S3OutpostsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new S3OutpostsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class S3OutpostsImpl[R](
      override val api: S3OutpostsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends S3Outposts
      with AwsServiceBase[R] {
    override val serviceName: String = "S3Outposts"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): S3OutpostsImpl[R1] = new S3OutpostsImpl(api, newAspect, r)
    def createEndpoint(
        request: CreateEndpointRequest
    ): IO[AwsError, zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest,
        CreateEndpointResponse
      ]("createEndpoint", api.createEndpoint)(request.buildAwsValue())
        .map(zio.aws.s3outposts.model.CreateEndpointResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest,
        DeleteEndpointResponse
      ]("deleteEndpoint", api.deleteEndpoint)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listEndpoints(
        request: ListEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.s3outposts.model.Endpoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest,
        ListEndpointsResponse,
        Endpoint
      ](
        "listEndpoints",
        api.listEndpoints,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.endpoints().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.s3outposts.model.Endpoint.wrap(item))
        .provideEnvironment(r)
    def listEndpointsPaginated(
        request: ListEndpointsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest,
      ListEndpointsResponse
    ]("listEndpoints", api.listEndpoints)(request.buildAwsValue())
      .map(zio.aws.s3outposts.model.ListEndpointsResponse.wrap)
      .provideEnvironment(r)
  }
  def createEndpoint(request: CreateEndpointRequest): ZIO[
    zio.aws.s3outposts.S3Outposts,
    AwsError,
    zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def deleteEndpoint(
      request: DeleteEndpointRequest
  ): ZIO[zio.aws.s3outposts.S3Outposts, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def listEndpoints(request: ListEndpointsRequest): ZStream[
    zio.aws.s3outposts.S3Outposts,
    AwsError,
    zio.aws.s3outposts.model.Endpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpoints(request))
  def listEndpointsPaginated(
      request: ListEndpointsRequest
  ): ZIO[zio.aws.s3outposts.S3Outposts, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listEndpointsPaginated(request))
}
