package zio.aws.s3outposts
import zio.aws.s3outposts.model.ListEndpointsResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.s3outposts.model.{
  ListEndpointsRequest,
  DeleteEndpointRequest,
  CreateEndpointRequest
}
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object S3OutpostsMock extends Mock[S3Outposts] {
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly
      ]
  object DeleteEndpoint extends Effect[DeleteEndpointRequest, AwsError, Unit]
  object ListEndpoints
      extends Stream[
        ListEndpointsRequest,
        AwsError,
        zio.aws.s3outposts.model.Endpoint.ReadOnly
      ]
  object ListEndpointsPaginated
      extends Effect[ListEndpointsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, S3Outposts] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new S3Outposts {
          val api: S3OutpostsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : S3Outposts = this
          def createEndpoint(request: CreateEndpointRequest): IO[
            AwsError,
            zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly
          ] = proxy(CreateEndpoint, request)
          def deleteEndpoint(
              request: DeleteEndpointRequest
          ): IO[AwsError, Unit] = proxy(DeleteEndpoint, request)
          def listEndpoints(request: ListEndpointsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.s3outposts.model.Endpoint.ReadOnly
          ] = rts.unsafeRun(proxy(ListEndpoints, request))
          def listEndpointsPaginated(
              request: ListEndpointsRequest
          ): IO[AwsError, ReadOnly] = proxy(ListEndpointsPaginated, request)
        }
      }
    }
    .toLayer
}
