package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.{
  CustomerOwnedIpv4Pool,
  SecurityGroupId,
  SubnetId,
  OutpostId
}
import scala.jdk.CollectionConverters.*
final case class CreateEndpointRequest(
    outpostId: OutpostId,
    subnetId: SubnetId,
    securityGroupId: SecurityGroupId,
    accessType: Option[zio.aws.s3outposts.model.EndpointAccessType] = None,
    customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest = {
    import CreateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest
      .builder()
      .outpostId(OutpostId.unwrap(outpostId): java.lang.String)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .securityGroupId(
        SecurityGroupId.unwrap(securityGroupId): java.lang.String
      )
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CustomerOwnedIpv4Pool.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.CreateEndpointRequest.ReadOnly =
    zio.aws.s3outposts.model.CreateEndpointRequest.wrap(buildAwsValue())
}
object CreateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.CreateEndpointRequest =
      zio.aws.s3outposts.model.CreateEndpointRequest(
        outpostId,
        subnetId,
        securityGroupId,
        accessType.map(value => value),
        customerOwnedIpv4Pool.map(value => value)
      )
    def outpostId: OutpostId
    def subnetId: SubnetId
    def securityGroupId: SecurityGroupId
    def accessType: Option[zio.aws.s3outposts.model.EndpointAccessType]
    def customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool]
    def getOutpostId: ZIO[Any, Nothing, OutpostId] = ZIO.succeed(outpostId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getSecurityGroupId: ZIO[Any, Nothing, SecurityGroupId] =
      ZIO.succeed(securityGroupId)
    def getAccessType
        : ZIO[Any, AwsError, zio.aws.s3outposts.model.EndpointAccessType] =
      AwsError.unwrapOptionField("accessType", accessType)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CustomerOwnedIpv4Pool] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest
  ) extends zio.aws.s3outposts.model.CreateEndpointRequest.ReadOnly {
    override val outpostId: OutpostId =
      zio.aws.s3outposts.model.primitives.OutpostId(impl.outpostId())
    override val subnetId: SubnetId =
      zio.aws.s3outposts.model.primitives.SubnetId(impl.subnetId())
    override val securityGroupId: SecurityGroupId =
      zio.aws.s3outposts.model.primitives
        .SecurityGroupId(impl.securityGroupId())
    override val accessType
        : Option[zio.aws.s3outposts.model.EndpointAccessType] = scala
      .Option(impl.accessType())
      .map(value => zio.aws.s3outposts.model.EndpointAccessType.wrap(value))
    override val customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = scala
      .Option(impl.customerOwnedIpv4Pool())
      .map(value =>
        zio.aws.s3outposts.model.primitives.CustomerOwnedIpv4Pool(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest
  ): zio.aws.s3outposts.model.CreateEndpointRequest.ReadOnly = new Wrapper(impl)
}
