package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.EndpointArn
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(
    endpointArn: Option[EndpointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse
      .builder()
      .optionallyWith(
        endpointArn.map(value => EndpointArn.unwrap(value): java.lang.String)
      )(_.endpointArn)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly =
    zio.aws.s3outposts.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.CreateEndpointResponse =
      zio.aws.s3outposts.model
        .CreateEndpointResponse(endpointArn.map(value => value))
    def endpointArn: Option[EndpointArn]
    def getEndpointArn: ZIO[Any, AwsError, EndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse
  ) extends zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly {
    override val endpointArn: Option[EndpointArn] = scala
      .Option(impl.endpointArn())
      .map(value => zio.aws.s3outposts.model.primitives.EndpointArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse
  ): zio.aws.s3outposts.model.CreateEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
