package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3outposts.model.primitives.{OutpostId, EndpointId}
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointRequest(
    endpointId: EndpointId,
    outpostId: OutpostId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest
      .builder()
      .endpointId(EndpointId.unwrap(endpointId): java.lang.String)
      .outpostId(OutpostId.unwrap(outpostId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.s3outposts.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.DeleteEndpointRequest =
      zio.aws.s3outposts.model.DeleteEndpointRequest(endpointId, outpostId)
    def endpointId: EndpointId
    def outpostId: OutpostId
    def getEndpointId: ZIO[Any, Nothing, EndpointId] = ZIO.succeed(endpointId)
    def getOutpostId: ZIO[Any, Nothing, OutpostId] = ZIO.succeed(outpostId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest
  ) extends zio.aws.s3outposts.model.DeleteEndpointRequest.ReadOnly {
    override val endpointId: EndpointId =
      zio.aws.s3outposts.model.primitives.EndpointId(impl.endpointId())
    override val outpostId: OutpostId =
      zio.aws.s3outposts.model.primitives.OutpostId(impl.outpostId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest
  ): zio.aws.s3outposts.model.DeleteEndpointRequest.ReadOnly = new Wrapper(impl)
}
