package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  OutpostId,
  SecurityGroupId,
  EndpointArn,
  CidrBlock,
  CustomerOwnedIpv4Pool
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    endpointArn: Option[EndpointArn] = None,
    outpostsId: Option[OutpostId] = None,
    cidrBlock: Option[CidrBlock] = None,
    status: Option[zio.aws.s3outposts.model.EndpointStatus] = None,
    creationTime: Option[CreationTime] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.s3outposts.model.NetworkInterface]
    ] = None,
    vpcId: Option[VpcId] = None,
    subnetId: Option[SubnetId] = None,
    securityGroupId: Option[SecurityGroupId] = None,
    accessType: Option[zio.aws.s3outposts.model.EndpointAccessType] = None,
    customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.Endpoint
      .builder()
      .optionallyWith(
        endpointArn.map(value => EndpointArn.unwrap(value): java.lang.String)
      )(_.endpointArn)
      .optionallyWith(
        outpostsId.map(value => OutpostId.unwrap(value): java.lang.String)
      )(_.outpostsId)
      .optionallyWith(
        cidrBlock.map(value => CidrBlock.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        securityGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.securityGroupId)
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CustomerOwnedIpv4Pool.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.Endpoint.ReadOnly =
    zio.aws.s3outposts.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.Endpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.Endpoint =
      zio.aws.s3outposts.model.Endpoint(
        endpointArn.map(value => value),
        outpostsId.map(value => value),
        cidrBlock.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value),
        subnetId.map(value => value),
        securityGroupId.map(value => value),
        accessType.map(value => value),
        customerOwnedIpv4Pool.map(value => value)
      )
    def endpointArn: Option[EndpointArn]
    def outpostsId: Option[OutpostId]
    def cidrBlock: Option[CidrBlock]
    def status: Option[zio.aws.s3outposts.model.EndpointStatus]
    def creationTime: Option[CreationTime]
    def networkInterfaces
        : Option[List[zio.aws.s3outposts.model.NetworkInterface.ReadOnly]]
    def vpcId: Option[VpcId]
    def subnetId: Option[SubnetId]
    def securityGroupId: Option[SecurityGroupId]
    def accessType: Option[zio.aws.s3outposts.model.EndpointAccessType]
    def customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool]
    def getEndpointArn: ZIO[Any, AwsError, EndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getOutpostsId: ZIO[Any, AwsError, OutpostId] =
      AwsError.unwrapOptionField("outpostsId", outpostsId)
    def getCidrBlock: ZIO[Any, AwsError, CidrBlock] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3outposts.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.s3outposts.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSecurityGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("securityGroupId", securityGroupId)
    def getAccessType
        : ZIO[Any, AwsError, zio.aws.s3outposts.model.EndpointAccessType] =
      AwsError.unwrapOptionField("accessType", accessType)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CustomerOwnedIpv4Pool] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.Endpoint
  ) extends zio.aws.s3outposts.model.Endpoint.ReadOnly {
    override val endpointArn: Option[EndpointArn] = scala
      .Option(impl.endpointArn())
      .map(value => zio.aws.s3outposts.model.primitives.EndpointArn(value))
    override val outpostsId: Option[OutpostId] = scala
      .Option(impl.outpostsId())
      .map(value => zio.aws.s3outposts.model.primitives.OutpostId(value))
    override val cidrBlock: Option[CidrBlock] = scala
      .Option(impl.cidrBlock())
      .map(value => zio.aws.s3outposts.model.primitives.CidrBlock(value))
    override val status: Option[zio.aws.s3outposts.model.EndpointStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3outposts.model.EndpointStatus.wrap(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.s3outposts.model.primitives.CreationTime(value))
    override val networkInterfaces
        : Option[List[zio.aws.s3outposts.model.NetworkInterface.ReadOnly]] =
      scala
        .Option(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3outposts.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.s3outposts.model.primitives.VpcId(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.s3outposts.model.primitives.SubnetId(value))
    override val securityGroupId: Option[SecurityGroupId] = scala
      .Option(impl.securityGroupId())
      .map(value => zio.aws.s3outposts.model.primitives.SecurityGroupId(value))
    override val accessType
        : Option[zio.aws.s3outposts.model.EndpointAccessType] = scala
      .Option(impl.accessType())
      .map(value => zio.aws.s3outposts.model.EndpointAccessType.wrap(value))
    override val customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = scala
      .Option(impl.customerOwnedIpv4Pool())
      .map(value =>
        zio.aws.s3outposts.model.primitives.CustomerOwnedIpv4Pool(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.Endpoint
  ): zio.aws.s3outposts.model.Endpoint.ReadOnly = new Wrapper(impl)
}
