package zio.aws.s3outposts.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointAccessType {
  def unwrap
      : software.amazon.awssdk.services.s3outposts.model.EndpointAccessType
}
object EndpointAccessType {
  def wrap(
      value: software.amazon.awssdk.services.s3outposts.model.EndpointAccessType
  ): zio.aws.s3outposts.model.EndpointAccessType = value match {
    case software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.PRIVATE =>
      val r = Private
      r
    case software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.CUSTOMER_OWNED_IP =>
      val r = CustomerOwnedIp
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3outposts.model.EndpointAccessType {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointAccessType =
      software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object Private extends zio.aws.s3outposts.model.EndpointAccessType {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointAccessType =
      software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.PRIVATE
  }
  case object CustomerOwnedIp
      extends zio.aws.s3outposts.model.EndpointAccessType {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointAccessType =
      software.amazon.awssdk.services.s3outposts.model.EndpointAccessType.CUSTOMER_OWNED_IP
  }
}
