package zio.aws.s3outposts.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointStatus {
  def unwrap: software.amazon.awssdk.services.s3outposts.model.EndpointStatus
}
object EndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3outposts.model.EndpointStatus
  ): zio.aws.s3outposts.model.EndpointStatus = value match {
    case software.amazon.awssdk.services.s3outposts.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3outposts.model.EndpointStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.s3outposts.model.EndpointStatus.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.s3outposts.model.EndpointStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3outposts.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointStatus =
      software.amazon.awssdk.services.s3outposts.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.s3outposts.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointStatus =
      software.amazon.awssdk.services.s3outposts.model.EndpointStatus.PENDING
  }
  case object Available extends zio.aws.s3outposts.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointStatus =
      software.amazon.awssdk.services.s3outposts.model.EndpointStatus.AVAILABLE
  }
  case object Deleting extends zio.aws.s3outposts.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3outposts.model.EndpointStatus =
      software.amazon.awssdk.services.s3outposts.model.EndpointStatus.DELETING
  }
}
