package zio.aws.s3outposts.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListEndpointsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest = {
    import ListEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.ListEndpointsRequest.ReadOnly =
    zio.aws.s3outposts.model.ListEndpointsRequest.wrap(buildAwsValue())
}
object ListEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.ListEndpointsRequest =
      zio.aws.s3outposts.model.ListEndpointsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest
  ) extends zio.aws.s3outposts.model.ListEndpointsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.s3outposts.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.s3outposts.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest
  ): zio.aws.s3outposts.model.ListEndpointsRequest.ReadOnly = new Wrapper(impl)
}
