package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEndpointsResponse(
    endpoints: Option[Iterable[zio.aws.s3outposts.model.Endpoint]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse = {
    import ListEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse
      .builder()
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.ListEndpointsResponse.ReadOnly =
    zio.aws.s3outposts.model.ListEndpointsResponse.wrap(buildAwsValue())
}
object ListEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.ListEndpointsResponse =
      zio.aws.s3outposts.model.ListEndpointsResponse(
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpoints: Option[List[zio.aws.s3outposts.model.Endpoint.ReadOnly]]
    def nextToken: Option[NextToken]
    def getEndpoints
        : ZIO[Any, AwsError, List[zio.aws.s3outposts.model.Endpoint.ReadOnly]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse
  ) extends zio.aws.s3outposts.model.ListEndpointsResponse.ReadOnly {
    override val endpoints
        : Option[List[zio.aws.s3outposts.model.Endpoint.ReadOnly]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3outposts.model.Endpoint.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.s3outposts.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse
  ): zio.aws.s3outposts.model.ListEndpointsResponse.ReadOnly = new Wrapper(impl)
}
