package zio.aws.s3outposts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3outposts.model.primitives.NetworkInterfaceId
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    networkInterfaceId: Option[NetworkInterfaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3outposts.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3outposts.model.NetworkInterface
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .build()
  }
  def asReadOnly: zio.aws.s3outposts.model.NetworkInterface.ReadOnly =
    zio.aws.s3outposts.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3outposts.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3outposts.model.NetworkInterface =
      zio.aws.s3outposts.model
        .NetworkInterface(networkInterfaceId.map(value => value))
    def networkInterfaceId: Option[NetworkInterfaceId]
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3outposts.model.NetworkInterface
  ) extends zio.aws.s3outposts.model.NetworkInterface.ReadOnly {
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value =>
        zio.aws.s3outposts.model.primitives.NetworkInterfaceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3outposts.model.NetworkInterface
  ): zio.aws.s3outposts.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
