/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.sagemaker.model;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.ZIO;
import zio.ZIO$;
import zio.aws.core.AwsError;
import zio.aws.core.AwsError$;
import zio.aws.core.internal.package$;
import zio.aws.sagemaker.model.ResourceConfig$;
import zio.aws.sagemaker.model.TrainingInstanceType;
import zio.aws.sagemaker.model.TrainingInstanceType$;
import zio.aws.sagemaker.model.package$primitives$KmsKeyId$;
import zio.aws.sagemaker.model.package$primitives$TrainingInstanceCount$;
import zio.aws.sagemaker.model.package$primitives$VolumeSizeInGB$;
import zio.prelude.data.Optional;

public final class ResourceConfig
implements Product,
Serializable {
    private final TrainingInstanceType instanceType;
    private final int instanceCount;
    private final int volumeSizeInGB;
    private final Optional volumeKmsKeyId;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ResourceConfig$.class, "0bitmap$1");

    public static ResourceConfig apply(TrainingInstanceType trainingInstanceType, int n, int n2, Optional<String> optional) {
        return ResourceConfig$.MODULE$.apply(trainingInstanceType, n, n2, optional);
    }

    public static ResourceConfig fromProduct(Product product) {
        return ResourceConfig$.MODULE$.fromProduct(product);
    }

    public static ResourceConfig unapply(ResourceConfig resourceConfig) {
        return ResourceConfig$.MODULE$.unapply(resourceConfig);
    }

    public static ReadOnly wrap(software.amazon.awssdk.services.sagemaker.model.ResourceConfig resourceConfig) {
        return ResourceConfig$.MODULE$.wrap(resourceConfig);
    }

    public static Optional<String> $lessinit$greater$default$4() {
        return ResourceConfig$.MODULE$.$lessinit$greater$default$4();
    }

    public ResourceConfig(TrainingInstanceType instanceType, int instanceCount, int volumeSizeInGB, Optional<String> volumeKmsKeyId) {
        this.instanceType = instanceType;
        this.instanceCount = instanceCount;
        this.volumeSizeInGB = volumeSizeInGB;
        this.volumeKmsKeyId = volumeKmsKeyId;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ResourceConfig)) return false;
        ResourceConfig resourceConfig = (ResourceConfig)object;
        TrainingInstanceType trainingInstanceType = this.instanceType();
        TrainingInstanceType trainingInstanceType2 = resourceConfig.instanceType();
        if (trainingInstanceType == null) {
            if (trainingInstanceType2 != null) {
                return false;
            }
        } else if (!trainingInstanceType.equals(trainingInstanceType2)) return false;
        if (this.instanceCount() != resourceConfig.instanceCount()) return false;
        if (this.volumeSizeInGB() != resourceConfig.volumeSizeInGB()) return false;
        Optional<String> optional = this.volumeKmsKeyId();
        Optional<String> optional2 = resourceConfig.volumeKmsKeyId();
        if (optional == null) {
            if (optional2 == null) return true;
            return false;
        } else {
            if (!optional.equals(optional2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ResourceConfig;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "ResourceConfig";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "instanceType";
                break;
            }
            case 1: {
                string = "instanceCount";
                break;
            }
            case 2: {
                string = "volumeSizeInGB";
                break;
            }
            case 3: {
                string = "volumeKmsKeyId";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public TrainingInstanceType instanceType() {
        return this.instanceType;
    }

    public int instanceCount() {
        return this.instanceCount;
    }

    public int volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public Optional<String> volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public software.amazon.awssdk.services.sagemaker.model.ResourceConfig buildAwsValue() {
        return (software.amazon.awssdk.services.sagemaker.model.ResourceConfig)ResourceConfig$.MODULE$.zio$aws$sagemaker$model$ResourceConfig$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)software.amazon.awssdk.services.sagemaker.model.ResourceConfig.builder().instanceType(this.instanceType().unwrap()).instanceCount(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)package$primitives$TrainingInstanceCount$.MODULE$.unwrap(BoxesRunTime.boxToInteger((int)this.instanceCount()))))).volumeSizeInGB(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)package$primitives$VolumeSizeInGB$.MODULE$.unwrap(BoxesRunTime.boxToInteger((int)this.volumeSizeInGB())))))).optionallyWith(this.volumeKmsKeyId().map((Function1 & Serializable)value -> (String)package$primitives$KmsKeyId$.MODULE$.unwrap(value)), (Function1 & Serializable)_$1 -> (Function1 & Serializable)x$0 -> _$1.volumeKmsKeyId(x$0)).build();
    }

    public ReadOnly asReadOnly() {
        return ResourceConfig$.MODULE$.wrap(this.buildAwsValue());
    }

    public ResourceConfig copy(TrainingInstanceType instanceType, int instanceCount, int volumeSizeInGB, Optional<String> volumeKmsKeyId) {
        return new ResourceConfig(instanceType, instanceCount, volumeSizeInGB, volumeKmsKeyId);
    }

    public TrainingInstanceType copy$default$1() {
        return this.instanceType();
    }

    public int copy$default$2() {
        return this.instanceCount();
    }

    public int copy$default$3() {
        return this.volumeSizeInGB();
    }

    public Optional<String> copy$default$4() {
        return this.volumeKmsKeyId();
    }

    public TrainingInstanceType _1() {
        return this.instanceType();
    }

    public int _2() {
        return this.instanceCount();
    }

    public int _3() {
        return this.volumeSizeInGB();
    }

    public Optional<String> _4() {
        return this.volumeKmsKeyId();
    }

    public static interface ReadOnly {
        public static ResourceConfig asEditable$(ReadOnly $this) {
            return $this.asEditable();
        }

        default public ResourceConfig asEditable() {
            return ResourceConfig$.MODULE$.apply(this.instanceType(), this.instanceCount(), this.volumeSizeInGB(), (Optional<String>)this.volumeKmsKeyId().map((Function1 & Serializable)value -> value));
        }

        public TrainingInstanceType instanceType();

        public int instanceCount();

        public int volumeSizeInGB();

        public Optional<String> volumeKmsKeyId();

        public static ZIO getInstanceType$(ReadOnly $this) {
            return $this.getInstanceType();
        }

        default public ZIO<Object, Nothing$, TrainingInstanceType> getInstanceType() {
            return ZIO$.MODULE$.succeed(this::getInstanceType$$anonfun$1, (Object)"zio.aws.sagemaker.model.ResourceConfig$.ReadOnly.getInstanceType.macro(ResourceConfig.scala:52)");
        }

        public static ZIO getInstanceCount$(ReadOnly $this) {
            return $this.getInstanceCount();
        }

        default public ZIO<Object, Nothing$, Object> getInstanceCount() {
            return ZIO$.MODULE$.succeed(this::getInstanceCount$$anonfun$1, (Object)"zio.aws.sagemaker.model.ResourceConfig$.ReadOnly.getInstanceCount.macro(ResourceConfig.scala:54)");
        }

        public static ZIO getVolumeSizeInGB$(ReadOnly $this) {
            return $this.getVolumeSizeInGB();
        }

        default public ZIO<Object, Nothing$, Object> getVolumeSizeInGB() {
            return ZIO$.MODULE$.succeed(this::getVolumeSizeInGB$$anonfun$1, (Object)"zio.aws.sagemaker.model.ResourceConfig$.ReadOnly.getVolumeSizeInGB.macro(ResourceConfig.scala:56)");
        }

        public static ZIO getVolumeKmsKeyId$(ReadOnly $this) {
            return $this.getVolumeKmsKeyId();
        }

        default public ZIO<Object, AwsError, String> getVolumeKmsKeyId() {
            return AwsError$.MODULE$.unwrapOptionField("volumeKmsKeyId", this::getVolumeKmsKeyId$$anonfun$1);
        }

        private TrainingInstanceType getInstanceType$$anonfun$1() {
            return this.instanceType();
        }

        private int getInstanceCount$$anonfun$1() {
            return this.instanceCount();
        }

        private int getVolumeSizeInGB$$anonfun$1() {
            return this.volumeSizeInGB();
        }

        private Optional getVolumeKmsKeyId$$anonfun$1() {
            return this.volumeKmsKeyId();
        }
    }

    private static final class Wrapper
    implements ReadOnly {
        private final TrainingInstanceType instanceType;
        private final int instanceCount;
        private final int volumeSizeInGB;
        private final Optional volumeKmsKeyId;

        public Wrapper(software.amazon.awssdk.services.sagemaker.model.ResourceConfig impl) {
            this.instanceType = TrainingInstanceType$.MODULE$.wrap(impl.instanceType());
            package$primitives$TrainingInstanceCount$ Newtype_this = package$primitives$TrainingInstanceCount$.MODULE$;
            this.instanceCount = Predef$.MODULE$.Integer2int(impl.instanceCount());
            package$primitives$VolumeSizeInGB$ Newtype_this2 = package$primitives$VolumeSizeInGB$.MODULE$;
            this.volumeSizeInGB = Predef$.MODULE$.Integer2int(impl.volumeSizeInGB());
            this.volumeKmsKeyId = package$.MODULE$.optionalFromNullable((Object)impl.volumeKmsKeyId()).map((Function1 & Serializable)value -> {
                package$primitives$KmsKeyId$ Newtype_this = package$primitives$KmsKeyId$.MODULE$;
                return value;
            });
        }

        @Override
        public TrainingInstanceType instanceType() {
            return this.instanceType;
        }

        @Override
        public int instanceCount() {
            return this.instanceCount;
        }

        @Override
        public int volumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        @Override
        public Optional<String> volumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }
    }
}

