/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.sagemaker.model.Endpoint;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.ZIO;
import zio.ZIO$;
import zio.aws.core.AwsError;
import zio.aws.core.AwsError$;
import zio.aws.core.internal.package$;
import zio.aws.sagemaker.model.DataCaptureConfigSummary;
import zio.aws.sagemaker.model.DataCaptureConfigSummary$;
import zio.aws.sagemaker.model.Endpoint$;
import zio.aws.sagemaker.model.EndpointStatus;
import zio.aws.sagemaker.model.EndpointStatus$;
import zio.aws.sagemaker.model.MonitoringSchedule;
import zio.aws.sagemaker.model.MonitoringSchedule$;
import zio.aws.sagemaker.model.ProductionVariantSummary;
import zio.aws.sagemaker.model.ProductionVariantSummary$;
import zio.aws.sagemaker.model.Tag;
import zio.aws.sagemaker.model.Tag$;
import zio.aws.sagemaker.model.package$primitives$EndpointArn$;
import zio.aws.sagemaker.model.package$primitives$EndpointConfigName$;
import zio.aws.sagemaker.model.package$primitives$EndpointName$;
import zio.aws.sagemaker.model.package$primitives$FailureReason$;
import zio.aws.sagemaker.model.package$primitives$Timestamp$;
import zio.prelude.data.Optional;

public final class Endpoint
implements Product,
Serializable {
    private final String endpointName;
    private final String endpointArn;
    private final String endpointConfigName;
    private final Optional productionVariants;
    private final Optional dataCaptureConfig;
    private final EndpointStatus endpointStatus;
    private final Optional failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Optional monitoringSchedules;
    private final Optional tags;
    private final Optional shadowProductionVariants;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Endpoint$.class.getDeclaredField("0bitmap$1"));

    public static Endpoint apply(String string, String string2, String string3, Optional<Iterable<ProductionVariantSummary>> optional, Optional<DataCaptureConfigSummary> optional2, EndpointStatus endpointStatus, Optional<String> optional3, Instant instant, Instant instant2, Optional<Iterable<MonitoringSchedule>> optional4, Optional<Iterable<Tag>> optional5, Optional<Iterable<ProductionVariantSummary>> optional6) {
        return Endpoint$.MODULE$.apply(string, string2, string3, optional, optional2, endpointStatus, optional3, instant, instant2, optional4, optional5, optional6);
    }

    public static Endpoint fromProduct(Product product) {
        return Endpoint$.MODULE$.fromProduct(product);
    }

    public static Endpoint unapply(Endpoint endpoint) {
        return Endpoint$.MODULE$.unapply(endpoint);
    }

    public static ReadOnly wrap(software.amazon.awssdk.services.sagemaker.model.Endpoint endpoint) {
        return Endpoint$.MODULE$.wrap(endpoint);
    }

    public static Optional<Iterable<ProductionVariantSummary>> $lessinit$greater$default$4() {
        return Endpoint$.MODULE$.$lessinit$greater$default$4();
    }

    public static Optional<DataCaptureConfigSummary> $lessinit$greater$default$5() {
        return Endpoint$.MODULE$.$lessinit$greater$default$5();
    }

    public static Optional<String> $lessinit$greater$default$7() {
        return Endpoint$.MODULE$.$lessinit$greater$default$7();
    }

    public static Optional<Iterable<MonitoringSchedule>> $lessinit$greater$default$10() {
        return Endpoint$.MODULE$.$lessinit$greater$default$10();
    }

    public static Optional<Iterable<Tag>> $lessinit$greater$default$11() {
        return Endpoint$.MODULE$.$lessinit$greater$default$11();
    }

    public static Optional<Iterable<ProductionVariantSummary>> $lessinit$greater$default$12() {
        return Endpoint$.MODULE$.$lessinit$greater$default$12();
    }

    public Endpoint(String endpointName, String endpointArn, String endpointConfigName, Optional<Iterable<ProductionVariantSummary>> productionVariants, Optional<DataCaptureConfigSummary> dataCaptureConfig, EndpointStatus endpointStatus, Optional<String> failureReason, Instant creationTime, Instant lastModifiedTime, Optional<Iterable<MonitoringSchedule>> monitoringSchedules, Optional<Iterable<Tag>> tags, Optional<Iterable<ProductionVariantSummary>> shadowProductionVariants) {
        this.endpointName = endpointName;
        this.endpointArn = endpointArn;
        this.endpointConfigName = endpointConfigName;
        this.productionVariants = productionVariants;
        this.dataCaptureConfig = dataCaptureConfig;
        this.endpointStatus = endpointStatus;
        this.failureReason = failureReason;
        this.creationTime = creationTime;
        this.lastModifiedTime = lastModifiedTime;
        this.monitoringSchedules = monitoringSchedules;
        this.tags = tags;
        this.shadowProductionVariants = shadowProductionVariants;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Endpoint)) return false;
        Endpoint endpoint = (Endpoint)object;
        String string = this.endpointName();
        String string2 = endpoint.endpointName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.endpointArn();
        String string4 = endpoint.endpointArn();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.endpointConfigName();
        String string6 = endpoint.endpointConfigName();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        Optional<Iterable<ProductionVariantSummary>> optional = this.productionVariants();
        Optional<Iterable<ProductionVariantSummary>> optional2 = endpoint.productionVariants();
        if (optional == null) {
            if (optional2 != null) {
                return false;
            }
        } else if (!optional.equals(optional2)) return false;
        Optional<DataCaptureConfigSummary> optional3 = this.dataCaptureConfig();
        Optional<DataCaptureConfigSummary> optional4 = endpoint.dataCaptureConfig();
        if (optional3 == null) {
            if (optional4 != null) {
                return false;
            }
        } else if (!optional3.equals(optional4)) return false;
        EndpointStatus endpointStatus = this.endpointStatus();
        EndpointStatus endpointStatus2 = endpoint.endpointStatus();
        if (endpointStatus == null) {
            if (endpointStatus2 != null) {
                return false;
            }
        } else if (!endpointStatus.equals(endpointStatus2)) return false;
        Optional<String> optional5 = this.failureReason();
        Optional<String> optional6 = endpoint.failureReason();
        if (optional5 == null) {
            if (optional6 != null) {
                return false;
            }
        } else if (!optional5.equals(optional6)) return false;
        Instant instant = this.creationTime();
        Instant instant2 = endpoint.creationTime();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        Instant instant3 = this.lastModifiedTime();
        Instant instant4 = endpoint.lastModifiedTime();
        if (instant3 == null) {
            if (instant4 != null) {
                return false;
            }
        } else if (!((Object)instant3).equals(instant4)) return false;
        Optional<Iterable<MonitoringSchedule>> optional7 = this.monitoringSchedules();
        Optional<Iterable<MonitoringSchedule>> optional8 = endpoint.monitoringSchedules();
        if (optional7 == null) {
            if (optional8 != null) {
                return false;
            }
        } else if (!optional7.equals(optional8)) return false;
        Optional<Iterable<Tag>> optional9 = this.tags();
        Optional<Iterable<Tag>> optional10 = endpoint.tags();
        if (optional9 == null) {
            if (optional10 != null) {
                return false;
            }
        } else if (!optional9.equals(optional10)) return false;
        Optional<Iterable<ProductionVariantSummary>> optional11 = this.shadowProductionVariants();
        Optional<Iterable<ProductionVariantSummary>> optional12 = endpoint.shadowProductionVariants();
        if (optional11 == null) {
            if (optional12 == null) return true;
            return false;
        } else {
            if (!optional11.equals(optional12)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Endpoint;
    }

    public int productArity() {
        return 12;
    }

    public String productPrefix() {
        return "Endpoint";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return this._11();
            }
            case 11: {
                return this._12();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "endpointName";
            }
            case 1: {
                return "endpointArn";
            }
            case 2: {
                return "endpointConfigName";
            }
            case 3: {
                return "productionVariants";
            }
            case 4: {
                return "dataCaptureConfig";
            }
            case 5: {
                return "endpointStatus";
            }
            case 6: {
                return "failureReason";
            }
            case 7: {
                return "creationTime";
            }
            case 8: {
                return "lastModifiedTime";
            }
            case 9: {
                return "monitoringSchedules";
            }
            case 10: {
                return "tags";
            }
            case 11: {
                return "shadowProductionVariants";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public Optional<Iterable<ProductionVariantSummary>> productionVariants() {
        return this.productionVariants;
    }

    public Optional<DataCaptureConfigSummary> dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public EndpointStatus endpointStatus() {
        return this.endpointStatus;
    }

    public Optional<String> failureReason() {
        return this.failureReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Optional<Iterable<MonitoringSchedule>> monitoringSchedules() {
        return this.monitoringSchedules;
    }

    public Optional<Iterable<Tag>> tags() {
        return this.tags;
    }

    public Optional<Iterable<ProductionVariantSummary>> shadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public software.amazon.awssdk.services.sagemaker.model.Endpoint buildAwsValue() {
        return (software.amazon.awssdk.services.sagemaker.model.Endpoint)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps(Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps(Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)((Endpoint.Builder)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)((Endpoint.Builder)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps(Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)software.amazon.awssdk.services.sagemaker.model.Endpoint.builder().endpointName((String)package$primitives$EndpointName$.MODULE$.unwrap(this.endpointName())).endpointArn((String)package$primitives$EndpointArn$.MODULE$.unwrap(this.endpointArn())).endpointConfigName((String)package$primitives$EndpointConfigName$.MODULE$.unwrap(this.endpointConfigName()))).optionallyWith(this.productionVariants().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$1 -> (Function1 & Serializable)x$0 -> _$1.productionVariants(x$0))).optionallyWith(this.dataCaptureConfig().map((Function1 & Serializable)value -> value.buildAwsValue()), (Function1 & Serializable)_$2 -> (Function1 & Serializable)x$0 -> _$2.dataCaptureConfig(x$0))).endpointStatus(this.endpointStatus().unwrap())).optionallyWith(this.failureReason().map((Function1 & Serializable)value -> (String)package$primitives$FailureReason$.MODULE$.unwrap(value)), (Function1 & Serializable)_$3 -> (Function1 & Serializable)x$0 -> _$3.failureReason(x$0))).creationTime((Instant)package$primitives$Timestamp$.MODULE$.unwrap(this.creationTime())).lastModifiedTime((Instant)package$primitives$Timestamp$.MODULE$.unwrap(this.lastModifiedTime()))).optionallyWith(this.monitoringSchedules().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$4 -> (Function1 & Serializable)x$0 -> _$4.monitoringSchedules(x$0))).optionallyWith(this.tags().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$5 -> (Function1 & Serializable)x$0 -> _$5.tags(x$0))).optionallyWith(this.shadowProductionVariants().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$6 -> (Function1 & Serializable)x$0 -> _$6.shadowProductionVariants(x$0)).build();
    }

    public ReadOnly asReadOnly() {
        return Endpoint$.MODULE$.wrap(this.buildAwsValue());
    }

    public Endpoint copy(String endpointName, String endpointArn, String endpointConfigName, Optional<Iterable<ProductionVariantSummary>> productionVariants, Optional<DataCaptureConfigSummary> dataCaptureConfig, EndpointStatus endpointStatus, Optional<String> failureReason, Instant creationTime, Instant lastModifiedTime, Optional<Iterable<MonitoringSchedule>> monitoringSchedules, Optional<Iterable<Tag>> tags, Optional<Iterable<ProductionVariantSummary>> shadowProductionVariants) {
        return new Endpoint(endpointName, endpointArn, endpointConfigName, productionVariants, dataCaptureConfig, endpointStatus, failureReason, creationTime, lastModifiedTime, monitoringSchedules, tags, shadowProductionVariants);
    }

    public String copy$default$1() {
        return this.endpointName();
    }

    public String copy$default$2() {
        return this.endpointArn();
    }

    public String copy$default$3() {
        return this.endpointConfigName();
    }

    public Optional<Iterable<ProductionVariantSummary>> copy$default$4() {
        return this.productionVariants();
    }

    public Optional<DataCaptureConfigSummary> copy$default$5() {
        return this.dataCaptureConfig();
    }

    public EndpointStatus copy$default$6() {
        return this.endpointStatus();
    }

    public Optional<String> copy$default$7() {
        return this.failureReason();
    }

    public Instant copy$default$8() {
        return this.creationTime();
    }

    public Instant copy$default$9() {
        return this.lastModifiedTime();
    }

    public Optional<Iterable<MonitoringSchedule>> copy$default$10() {
        return this.monitoringSchedules();
    }

    public Optional<Iterable<Tag>> copy$default$11() {
        return this.tags();
    }

    public Optional<Iterable<ProductionVariantSummary>> copy$default$12() {
        return this.shadowProductionVariants();
    }

    public String _1() {
        return this.endpointName();
    }

    public String _2() {
        return this.endpointArn();
    }

    public String _3() {
        return this.endpointConfigName();
    }

    public Optional<Iterable<ProductionVariantSummary>> _4() {
        return this.productionVariants();
    }

    public Optional<DataCaptureConfigSummary> _5() {
        return this.dataCaptureConfig();
    }

    public EndpointStatus _6() {
        return this.endpointStatus();
    }

    public Optional<String> _7() {
        return this.failureReason();
    }

    public Instant _8() {
        return this.creationTime();
    }

    public Instant _9() {
        return this.lastModifiedTime();
    }

    public Optional<Iterable<MonitoringSchedule>> _10() {
        return this.monitoringSchedules();
    }

    public Optional<Iterable<Tag>> _11() {
        return this.tags();
    }

    public Optional<Iterable<ProductionVariantSummary>> _12() {
        return this.shadowProductionVariants();
    }

    public static interface ReadOnly {
        public static Endpoint asEditable$(ReadOnly $this) {
            return $this.asEditable();
        }

        default public Endpoint asEditable() {
            return Endpoint$.MODULE$.apply(this.endpointName(), this.endpointArn(), this.endpointConfigName(), (Optional<Iterable<ProductionVariantSummary>>)this.productionVariants().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())), (Optional<DataCaptureConfigSummary>)this.dataCaptureConfig().map((Function1 & Serializable)value -> value.asEditable()), this.endpointStatus(), (Optional<String>)this.failureReason().map((Function1 & Serializable)value -> value), this.creationTime(), this.lastModifiedTime(), (Optional<Iterable<MonitoringSchedule>>)this.monitoringSchedules().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())), (Optional<Iterable<Tag>>)this.tags().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())), (Optional<Iterable<ProductionVariantSummary>>)this.shadowProductionVariants().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())));
        }

        public String endpointName();

        public String endpointArn();

        public String endpointConfigName();

        public Optional<List<ProductionVariantSummary.ReadOnly>> productionVariants();

        public Optional<DataCaptureConfigSummary.ReadOnly> dataCaptureConfig();

        public EndpointStatus endpointStatus();

        public Optional<String> failureReason();

        public Instant creationTime();

        public Instant lastModifiedTime();

        public Optional<List<MonitoringSchedule.ReadOnly>> monitoringSchedules();

        public Optional<List<Tag.ReadOnly>> tags();

        public Optional<List<ProductionVariantSummary.ReadOnly>> shadowProductionVariants();

        public static ZIO getEndpointName$(ReadOnly $this) {
            return $this.getEndpointName();
        }

        default public ZIO<Object, Nothing$, String> getEndpointName() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.endpointName(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getEndpointName(Endpoint.scala:145)");
        }

        public static ZIO getEndpointArn$(ReadOnly $this) {
            return $this.getEndpointArn();
        }

        default public ZIO<Object, Nothing$, String> getEndpointArn() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> this.endpointArn(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getEndpointArn(Endpoint.scala:147)");
        }

        public static ZIO getEndpointConfigName$(ReadOnly $this) {
            return $this.getEndpointConfigName();
        }

        default public ZIO<Object, Nothing$, String> getEndpointConfigName() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> this.endpointConfigName(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getEndpointConfigName(Endpoint.scala:149)");
        }

        public static ZIO getProductionVariants$(ReadOnly $this) {
            return $this.getProductionVariants();
        }

        default public ZIO<Object, AwsError, List<ProductionVariantSummary.ReadOnly>> getProductionVariants() {
            return AwsError$.MODULE$.unwrapOptionField("productionVariants", this::getProductionVariants$$anonfun$1);
        }

        public static ZIO getDataCaptureConfig$(ReadOnly $this) {
            return $this.getDataCaptureConfig();
        }

        default public ZIO<Object, AwsError, DataCaptureConfigSummary.ReadOnly> getDataCaptureConfig() {
            return AwsError$.MODULE$.unwrapOptionField("dataCaptureConfig", this::getDataCaptureConfig$$anonfun$1);
        }

        public static ZIO getEndpointStatus$(ReadOnly $this) {
            return $this.getEndpointStatus();
        }

        default public ZIO<Object, Nothing$, EndpointStatus> getEndpointStatus() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this.endpointStatus(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getEndpointStatus(Endpoint.scala:160)");
        }

        public static ZIO getFailureReason$(ReadOnly $this) {
            return $this.getFailureReason();
        }

        default public ZIO<Object, AwsError, String> getFailureReason() {
            return AwsError$.MODULE$.unwrapOptionField("failureReason", this::getFailureReason$$anonfun$1);
        }

        public static ZIO getCreationTime$(ReadOnly $this) {
            return $this.getCreationTime();
        }

        default public ZIO<Object, Nothing$, Instant> getCreationTime() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> this.creationTime(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getCreationTime(Endpoint.scala:164)");
        }

        public static ZIO getLastModifiedTime$(ReadOnly $this) {
            return $this.getLastModifiedTime();
        }

        default public ZIO<Object, Nothing$, Instant> getLastModifiedTime() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> this.lastModifiedTime(), (Object)"zio.aws.sagemaker.model.Endpoint.ReadOnly.getLastModifiedTime(Endpoint.scala:166)");
        }

        public static ZIO getMonitoringSchedules$(ReadOnly $this) {
            return $this.getMonitoringSchedules();
        }

        default public ZIO<Object, AwsError, List<MonitoringSchedule.ReadOnly>> getMonitoringSchedules() {
            return AwsError$.MODULE$.unwrapOptionField("monitoringSchedules", this::getMonitoringSchedules$$anonfun$1);
        }

        public static ZIO getTags$(ReadOnly $this) {
            return $this.getTags();
        }

        default public ZIO<Object, AwsError, List<Tag.ReadOnly>> getTags() {
            return AwsError$.MODULE$.unwrapOptionField("tags", this::getTags$$anonfun$1);
        }

        public static ZIO getShadowProductionVariants$(ReadOnly $this) {
            return $this.getShadowProductionVariants();
        }

        default public ZIO<Object, AwsError, List<ProductionVariantSummary.ReadOnly>> getShadowProductionVariants() {
            return AwsError$.MODULE$.unwrapOptionField("shadowProductionVariants", this::getShadowProductionVariants$$anonfun$1);
        }

        private Optional getProductionVariants$$anonfun$1() {
            return this.productionVariants();
        }

        private Optional getDataCaptureConfig$$anonfun$1() {
            return this.dataCaptureConfig();
        }

        private Optional getFailureReason$$anonfun$1() {
            return this.failureReason();
        }

        private Optional getMonitoringSchedules$$anonfun$1() {
            return this.monitoringSchedules();
        }

        private Optional getTags$$anonfun$1() {
            return this.tags();
        }

        private Optional getShadowProductionVariants$$anonfun$1() {
            return this.shadowProductionVariants();
        }
    }

    public static final class Wrapper
    implements ReadOnly {
        private final String endpointName;
        private final String endpointArn;
        private final String endpointConfigName;
        private final Optional productionVariants;
        private final Optional dataCaptureConfig;
        private final EndpointStatus endpointStatus;
        private final Optional failureReason;
        private final Instant creationTime;
        private final Instant lastModifiedTime;
        private final Optional monitoringSchedules;
        private final Optional tags;
        private final Optional shadowProductionVariants;

        public Wrapper(software.amazon.awssdk.services.sagemaker.model.Endpoint impl) {
            package$primitives$EndpointName$ NewtypeCustom_this = package$primitives$EndpointName$.MODULE$;
            this.endpointName = impl.endpointName();
            package$primitives$EndpointArn$ NewtypeCustom_this2 = package$primitives$EndpointArn$.MODULE$;
            this.endpointArn = impl.endpointArn();
            package$primitives$EndpointConfigName$ NewtypeCustom_this3 = package$primitives$EndpointConfigName$.MODULE$;
            this.endpointConfigName = impl.endpointConfigName();
            this.productionVariants = package$.MODULE$.optionalFromNullable((Object)impl.productionVariants()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> ProductionVariantSummary$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary)item))).toList());
            this.dataCaptureConfig = package$.MODULE$.optionalFromNullable((Object)impl.dataCaptureConfig()).map((Function1 & Serializable)value -> DataCaptureConfigSummary$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary)value));
            this.endpointStatus = EndpointStatus$.MODULE$.wrap(impl.endpointStatus());
            this.failureReason = package$.MODULE$.optionalFromNullable((Object)impl.failureReason()).map((Function1 & Serializable)value -> {
                package$primitives$FailureReason$ NewtypeCustom_this = package$primitives$FailureReason$.MODULE$;
                return value;
            });
            package$primitives$Timestamp$ NewtypeCustom_this4 = package$primitives$Timestamp$.MODULE$;
            this.creationTime = impl.creationTime();
            package$primitives$Timestamp$ NewtypeCustom_this5 = package$primitives$Timestamp$.MODULE$;
            this.lastModifiedTime = impl.lastModifiedTime();
            this.monitoringSchedules = package$.MODULE$.optionalFromNullable((Object)impl.monitoringSchedules()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> MonitoringSchedule$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule)item))).toList());
            this.tags = package$.MODULE$.optionalFromNullable((Object)impl.tags()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> Tag$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.Tag)item))).toList());
            this.shadowProductionVariants = package$.MODULE$.optionalFromNullable((Object)impl.shadowProductionVariants()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> ProductionVariantSummary$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary)item))).toList());
        }

        @Override
        public String endpointName() {
            return this.endpointName;
        }

        @Override
        public String endpointArn() {
            return this.endpointArn;
        }

        @Override
        public String endpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public Optional<List<ProductionVariantSummary.ReadOnly>> productionVariants() {
            return this.productionVariants;
        }

        @Override
        public Optional<DataCaptureConfigSummary.ReadOnly> dataCaptureConfig() {
            return this.dataCaptureConfig;
        }

        @Override
        public EndpointStatus endpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public Optional<String> failureReason() {
            return this.failureReason;
        }

        @Override
        public Instant creationTime() {
            return this.creationTime;
        }

        @Override
        public Instant lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public Optional<List<MonitoringSchedule.ReadOnly>> monitoringSchedules() {
            return this.monitoringSchedules;
        }

        @Override
        public Optional<List<Tag.ReadOnly>> tags() {
            return this.tags;
        }

        @Override
        public Optional<List<ProductionVariantSummary.ReadOnly>> shadowProductionVariants() {
            return this.shadowProductionVariants;
        }
    }
}

