package zio.aws.sfn
import zio.aws.sfn.model.ListTagsForResourceResponse.ReadOnly
import software.amazon.awssdk.services.sfn.model.{
  SendTaskFailureRequest,
  DescribeStateMachineForExecutionRequest,
  SendTaskHeartbeatRequest,
  CreateStateMachineResponse,
  StopExecutionResponse,
  ListActivitiesResponse,
  UpdateStateMachineRequest,
  DeleteStateMachineResponse,
  DescribeExecutionResponse,
  GetActivityTaskRequest,
  ListTagsForResourceRequest,
  DeleteActivityResponse,
  StartSyncExecutionRequest,
  GetExecutionHistoryRequest,
  CreateActivityResponse,
  ExecutionListItem,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  StartExecutionRequest,
  GetExecutionHistoryResponse,
  ListStateMachinesResponse,
  ListExecutionsRequest,
  SendTaskSuccessResponse,
  CreateStateMachineRequest,
  StateMachineListItem,
  DescribeStateMachineForExecutionResponse,
  CreateActivityRequest,
  DescribeActivityRequest,
  ListActivitiesRequest,
  GetActivityTaskResponse,
  SendTaskFailureResponse,
  SendTaskHeartbeatResponse,
  ListExecutionsResponse,
  StopExecutionRequest,
  DescribeStateMachineRequest,
  DeleteStateMachineRequest,
  UntagResourceRequest,
  ListStateMachinesRequest,
  ActivityListItem,
  DeleteActivityRequest,
  StartExecutionResponse,
  UpdateStateMachineResponse,
  SendTaskSuccessRequest,
  TagResourceResponse,
  DescribeStateMachineResponse,
  DescribeExecutionRequest,
  HistoryEvent,
  TagResourceRequest,
  StartSyncExecutionResponse,
  DescribeActivityResponse
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sfn.{
  SfnAsyncClientBuilder,
  SfnAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.sfn.paginators.{
  ListExecutionsPublisher,
  ListStateMachinesPublisher,
  ListActivitiesPublisher,
  GetExecutionHistoryPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Sfn extends AspectSupport[Sfn] {
  val api: SfnAsyncClient
  def startExecution(
      request: zio.aws.sfn.model.StartExecutionRequest
  ): IO[AwsError, zio.aws.sfn.model.StartExecutionResponse.ReadOnly]
  def getExecutionHistory(
      request: zio.aws.sfn.model.GetExecutionHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.sfn.model.HistoryEvent.ReadOnly]
  def getExecutionHistoryPaginated(
      request: zio.aws.sfn.model.GetExecutionHistoryRequest
  ): IO[AwsError, zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly]
  def deleteStateMachine(
      request: zio.aws.sfn.model.DeleteStateMachineRequest
  ): IO[AwsError, zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly]
  def createStateMachine(
      request: zio.aws.sfn.model.CreateStateMachineRequest
  ): IO[AwsError, zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly]
  def describeStateMachineForExecution(
      request: zio.aws.sfn.model.DescribeStateMachineForExecutionRequest
  ): IO[
    AwsError,
    zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
  ]
  def stopExecution(
      request: zio.aws.sfn.model.StopExecutionRequest
  ): IO[AwsError, zio.aws.sfn.model.StopExecutionResponse.ReadOnly]
  def getActivityTask(
      request: zio.aws.sfn.model.GetActivityTaskRequest
  ): IO[AwsError, zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly]
  def describeExecution(
      request: zio.aws.sfn.model.DescribeExecutionRequest
  ): IO[AwsError, zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly]
  def startSyncExecution(
      request: zio.aws.sfn.model.StartSyncExecutionRequest
  ): IO[AwsError, zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly]
  def sendTaskSuccess(
      request: zio.aws.sfn.model.SendTaskSuccessRequest
  ): IO[AwsError, zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly]
  def sendTaskHeartbeat(
      request: zio.aws.sfn.model.SendTaskHeartbeatRequest
  ): IO[AwsError, zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly]
  def describeStateMachine(
      request: zio.aws.sfn.model.DescribeStateMachineRequest
  ): IO[AwsError, zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly]
  def deleteActivity(
      request: zio.aws.sfn.model.DeleteActivityRequest
  ): IO[AwsError, zio.aws.sfn.model.DeleteActivityResponse.ReadOnly]
  def updateStateMachine(
      request: zio.aws.sfn.model.UpdateStateMachineRequest
  ): IO[AwsError, zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly]
  def untagResource(
      request: zio.aws.sfn.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.sfn.model.UntagResourceResponse.ReadOnly]
  def listActivities(
      request: zio.aws.sfn.model.ListActivitiesRequest
  ): ZStream[Any, AwsError, zio.aws.sfn.model.ActivityListItem.ReadOnly]
  def listActivitiesPaginated(
      request: zio.aws.sfn.model.ListActivitiesRequest
  ): IO[AwsError, zio.aws.sfn.model.ListActivitiesResponse.ReadOnly]
  def listStateMachines(
      request: zio.aws.sfn.model.ListStateMachinesRequest
  ): ZStream[Any, AwsError, zio.aws.sfn.model.StateMachineListItem.ReadOnly]
  def listStateMachinesPaginated(
      request: zio.aws.sfn.model.ListStateMachinesRequest
  ): IO[AwsError, zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly]
  def listExecutions(
      request: zio.aws.sfn.model.ListExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.sfn.model.ExecutionListItem.ReadOnly]
  def listExecutionsPaginated(
      request: zio.aws.sfn.model.ListExecutionsRequest
  ): IO[AwsError, zio.aws.sfn.model.ListExecutionsResponse.ReadOnly]
  def createActivity(
      request: zio.aws.sfn.model.CreateActivityRequest
  ): IO[AwsError, zio.aws.sfn.model.CreateActivityResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.sfn.model.ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def sendTaskFailure(
      request: zio.aws.sfn.model.SendTaskFailureRequest
  ): IO[AwsError, zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly]
  def tagResource(
      request: zio.aws.sfn.model.TagResourceRequest
  ): IO[AwsError, zio.aws.sfn.model.TagResourceResponse.ReadOnly]
  def describeActivity(
      request: zio.aws.sfn.model.DescribeActivityRequest
  ): IO[AwsError, zio.aws.sfn.model.DescribeActivityResponse.ReadOnly]
}
object Sfn {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sfn] = customized(identity)
  def customized(
      customization: SfnAsyncClientBuilder => SfnAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sfn] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SfnAsyncClientBuilder => SfnAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sfn] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SfnAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SfnAsyncClient, SfnAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SfnAsyncClient, SfnAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SfnImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SfnImpl[R](
      override val api: SfnAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sfn
      with AwsServiceBase[R] {
    override val serviceName: String = "Sfn"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SfnImpl[R1] = new SfnImpl(api, newAspect, r)
    def startExecution(
        request: zio.aws.sfn.model.StartExecutionRequest
    ): IO[AwsError, zio.aws.sfn.model.StartExecutionResponse.ReadOnly] =
      asyncRequestResponse[StartExecutionRequest, StartExecutionResponse](
        "startExecution",
        api.startExecution
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.StartExecutionResponse.wrap)
        .provideEnvironment(r)
    def getExecutionHistory(
        request: zio.aws.sfn.model.GetExecutionHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.sfn.model.HistoryEvent.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetExecutionHistoryRequest,
        HistoryEvent,
        GetExecutionHistoryPublisher
      ]("getExecutionHistory", api.getExecutionHistoryPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.sfn.model.HistoryEvent.wrap(item))
        .provideEnvironment(r)
    def getExecutionHistoryPaginated(
        request: zio.aws.sfn.model.GetExecutionHistoryRequest
    ): IO[AwsError, zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly] =
      asyncRequestResponse[
        GetExecutionHistoryRequest,
        GetExecutionHistoryResponse
      ]("getExecutionHistory", api.getExecutionHistory)(request.buildAwsValue())
        .map(zio.aws.sfn.model.GetExecutionHistoryResponse.wrap)
        .provideEnvironment(r)
    def deleteStateMachine(
        request: zio.aws.sfn.model.DeleteStateMachineRequest
    ): IO[AwsError, zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteStateMachineRequest,
        DeleteStateMachineResponse
      ]("deleteStateMachine", api.deleteStateMachine)(request.buildAwsValue())
        .map(zio.aws.sfn.model.DeleteStateMachineResponse.wrap)
        .provideEnvironment(r)
    def createStateMachine(
        request: zio.aws.sfn.model.CreateStateMachineRequest
    ): IO[AwsError, zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly] =
      asyncRequestResponse[
        CreateStateMachineRequest,
        CreateStateMachineResponse
      ]("createStateMachine", api.createStateMachine)(request.buildAwsValue())
        .map(zio.aws.sfn.model.CreateStateMachineResponse.wrap)
        .provideEnvironment(r)
    def describeStateMachineForExecution(
        request: zio.aws.sfn.model.DescribeStateMachineForExecutionRequest
    ): IO[
      AwsError,
      zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStateMachineForExecutionRequest,
      DescribeStateMachineForExecutionResponse
    ]("describeStateMachineForExecution", api.describeStateMachineForExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.wrap)
      .provideEnvironment(r)
    def stopExecution(
        request: zio.aws.sfn.model.StopExecutionRequest
    ): IO[AwsError, zio.aws.sfn.model.StopExecutionResponse.ReadOnly] =
      asyncRequestResponse[StopExecutionRequest, StopExecutionResponse](
        "stopExecution",
        api.stopExecution
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.StopExecutionResponse.wrap)
        .provideEnvironment(r)
    def getActivityTask(
        request: zio.aws.sfn.model.GetActivityTaskRequest
    ): IO[AwsError, zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly] =
      asyncRequestResponse[GetActivityTaskRequest, GetActivityTaskResponse](
        "getActivityTask",
        api.getActivityTask
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.GetActivityTaskResponse.wrap)
        .provideEnvironment(r)
    def describeExecution(
        request: zio.aws.sfn.model.DescribeExecutionRequest
    ): IO[AwsError, zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly] =
      asyncRequestResponse[DescribeExecutionRequest, DescribeExecutionResponse](
        "describeExecution",
        api.describeExecution
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.DescribeExecutionResponse.wrap)
        .provideEnvironment(r)
    def startSyncExecution(
        request: zio.aws.sfn.model.StartSyncExecutionRequest
    ): IO[AwsError, zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        StartSyncExecutionRequest,
        StartSyncExecutionResponse
      ]("startSyncExecution", api.startSyncExecution)(request.buildAwsValue())
        .map(zio.aws.sfn.model.StartSyncExecutionResponse.wrap)
        .provideEnvironment(r)
    def sendTaskSuccess(
        request: zio.aws.sfn.model.SendTaskSuccessRequest
    ): IO[AwsError, zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly] =
      asyncRequestResponse[SendTaskSuccessRequest, SendTaskSuccessResponse](
        "sendTaskSuccess",
        api.sendTaskSuccess
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.SendTaskSuccessResponse.wrap)
        .provideEnvironment(r)
    def sendTaskHeartbeat(
        request: zio.aws.sfn.model.SendTaskHeartbeatRequest
    ): IO[AwsError, zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly] =
      asyncRequestResponse[SendTaskHeartbeatRequest, SendTaskHeartbeatResponse](
        "sendTaskHeartbeat",
        api.sendTaskHeartbeat
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.SendTaskHeartbeatResponse.wrap)
        .provideEnvironment(r)
    def describeStateMachine(
        request: zio.aws.sfn.model.DescribeStateMachineRequest
    ): IO[AwsError, zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeStateMachineRequest,
        DescribeStateMachineResponse
      ]("describeStateMachine", api.describeStateMachine)(
        request.buildAwsValue()
      ).map(zio.aws.sfn.model.DescribeStateMachineResponse.wrap)
        .provideEnvironment(r)
    def deleteActivity(
        request: zio.aws.sfn.model.DeleteActivityRequest
    ): IO[AwsError, zio.aws.sfn.model.DeleteActivityResponse.ReadOnly] =
      asyncRequestResponse[DeleteActivityRequest, DeleteActivityResponse](
        "deleteActivity",
        api.deleteActivity
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.DeleteActivityResponse.wrap)
        .provideEnvironment(r)
    def updateStateMachine(
        request: zio.aws.sfn.model.UpdateStateMachineRequest
    ): IO[AwsError, zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateStateMachineRequest,
        UpdateStateMachineResponse
      ]("updateStateMachine", api.updateStateMachine)(request.buildAwsValue())
        .map(zio.aws.sfn.model.UpdateStateMachineResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.sfn.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.sfn.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listActivities(
        request: zio.aws.sfn.model.ListActivitiesRequest
    ): ZStream[Any, AwsError, zio.aws.sfn.model.ActivityListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListActivitiesRequest,
        ActivityListItem,
        ListActivitiesPublisher
      ]("listActivities", api.listActivitiesPaginator, _.activities())(
        request.buildAwsValue()
      ).map(item => zio.aws.sfn.model.ActivityListItem.wrap(item))
        .provideEnvironment(r)
    def listActivitiesPaginated(
        request: zio.aws.sfn.model.ListActivitiesRequest
    ): IO[AwsError, zio.aws.sfn.model.ListActivitiesResponse.ReadOnly] =
      asyncRequestResponse[ListActivitiesRequest, ListActivitiesResponse](
        "listActivities",
        api.listActivities
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.ListActivitiesResponse.wrap)
        .provideEnvironment(r)
    def listStateMachines(
        request: zio.aws.sfn.model.ListStateMachinesRequest
    ): ZStream[Any, AwsError, zio.aws.sfn.model.StateMachineListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListStateMachinesRequest,
        StateMachineListItem,
        ListStateMachinesPublisher
      ]("listStateMachines", api.listStateMachinesPaginator, _.stateMachines())(
        request.buildAwsValue()
      ).map(item => zio.aws.sfn.model.StateMachineListItem.wrap(item))
        .provideEnvironment(r)
    def listStateMachinesPaginated(
        request: zio.aws.sfn.model.ListStateMachinesRequest
    ): IO[AwsError, zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly] =
      asyncRequestResponse[ListStateMachinesRequest, ListStateMachinesResponse](
        "listStateMachines",
        api.listStateMachines
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.ListStateMachinesResponse.wrap)
        .provideEnvironment(r)
    def listExecutions(
        request: zio.aws.sfn.model.ListExecutionsRequest
    ): ZStream[Any, AwsError, zio.aws.sfn.model.ExecutionListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListExecutionsRequest,
        ExecutionListItem,
        ListExecutionsPublisher
      ]("listExecutions", api.listExecutionsPaginator, _.executions())(
        request.buildAwsValue()
      ).map(item => zio.aws.sfn.model.ExecutionListItem.wrap(item))
        .provideEnvironment(r)
    def listExecutionsPaginated(
        request: zio.aws.sfn.model.ListExecutionsRequest
    ): IO[AwsError, zio.aws.sfn.model.ListExecutionsResponse.ReadOnly] =
      asyncRequestResponse[ListExecutionsRequest, ListExecutionsResponse](
        "listExecutions",
        api.listExecutions
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.ListExecutionsResponse.wrap)
        .provideEnvironment(r)
    def createActivity(
        request: zio.aws.sfn.model.CreateActivityRequest
    ): IO[AwsError, zio.aws.sfn.model.CreateActivityResponse.ReadOnly] =
      asyncRequestResponse[CreateActivityRequest, CreateActivityResponse](
        "createActivity",
        api.createActivity
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.CreateActivityResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.sfn.model.ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.sfn.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def sendTaskFailure(
        request: zio.aws.sfn.model.SendTaskFailureRequest
    ): IO[AwsError, zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly] =
      asyncRequestResponse[SendTaskFailureRequest, SendTaskFailureResponse](
        "sendTaskFailure",
        api.sendTaskFailure
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.SendTaskFailureResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.sfn.model.TagResourceRequest
    ): IO[AwsError, zio.aws.sfn.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeActivity(
        request: zio.aws.sfn.model.DescribeActivityRequest
    ): IO[AwsError, zio.aws.sfn.model.DescribeActivityResponse.ReadOnly] =
      asyncRequestResponse[DescribeActivityRequest, DescribeActivityResponse](
        "describeActivity",
        api.describeActivity
      )(request.buildAwsValue())
        .map(zio.aws.sfn.model.DescribeActivityResponse.wrap)
        .provideEnvironment(r)
  }
  def startExecution(request: zio.aws.sfn.model.StartExecutionRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.StartExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExecution(request))
  def getExecutionHistory(
      request: zio.aws.sfn.model.GetExecutionHistoryRequest
  ): ZStream[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.HistoryEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.getExecutionHistory(request))
  def getExecutionHistoryPaginated(
      request: zio.aws.sfn.model.GetExecutionHistoryRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExecutionHistoryPaginated(request))
  def deleteStateMachine(
      request: zio.aws.sfn.model.DeleteStateMachineRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStateMachine(request))
  def createStateMachine(
      request: zio.aws.sfn.model.CreateStateMachineRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStateMachine(request))
  def describeStateMachineForExecution(
      request: zio.aws.sfn.model.DescribeStateMachineForExecutionRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStateMachineForExecution(request))
  def stopExecution(request: zio.aws.sfn.model.StopExecutionRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.StopExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopExecution(request))
  def getActivityTask(request: zio.aws.sfn.model.GetActivityTaskRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getActivityTask(request))
  def describeExecution(
      request: zio.aws.sfn.model.DescribeExecutionRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExecution(request))
  def startSyncExecution(
      request: zio.aws.sfn.model.StartSyncExecutionRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSyncExecution(request))
  def sendTaskSuccess(request: zio.aws.sfn.model.SendTaskSuccessRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTaskSuccess(request))
  def sendTaskHeartbeat(
      request: zio.aws.sfn.model.SendTaskHeartbeatRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTaskHeartbeat(request))
  def describeStateMachine(
      request: zio.aws.sfn.model.DescribeStateMachineRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStateMachine(request))
  def deleteActivity(request: zio.aws.sfn.model.DeleteActivityRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DeleteActivityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteActivity(request))
  def updateStateMachine(
      request: zio.aws.sfn.model.UpdateStateMachineRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStateMachine(request))
  def untagResource(request: zio.aws.sfn.model.UntagResourceRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listActivities(request: zio.aws.sfn.model.ListActivitiesRequest): ZStream[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.ActivityListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listActivities(request))
  def listActivitiesPaginated(
      request: zio.aws.sfn.model.ListActivitiesRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.ListActivitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActivitiesPaginated(request))
  def listStateMachines(
      request: zio.aws.sfn.model.ListStateMachinesRequest
  ): ZStream[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.StateMachineListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listStateMachines(request))
  def listStateMachinesPaginated(
      request: zio.aws.sfn.model.ListStateMachinesRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStateMachinesPaginated(request))
  def listExecutions(request: zio.aws.sfn.model.ListExecutionsRequest): ZStream[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.ExecutionListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listExecutions(request))
  def listExecutionsPaginated(
      request: zio.aws.sfn.model.ListExecutionsRequest
  ): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.ListExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExecutionsPaginated(request))
  def createActivity(request: zio.aws.sfn.model.CreateActivityRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.CreateActivityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createActivity(request))
  def listTagsForResource(
      request: zio.aws.sfn.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.sfn.Sfn, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def sendTaskFailure(request: zio.aws.sfn.model.SendTaskFailureRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTaskFailure(request))
  def tagResource(request: zio.aws.sfn.model.TagResourceRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeActivity(request: zio.aws.sfn.model.DescribeActivityRequest): ZIO[
    zio.aws.sfn.Sfn,
    AwsError,
    zio.aws.sfn.model.DescribeActivityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActivity(request))
}
