package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{TimeoutInSeconds, SensitiveData, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivityScheduledEventDetails(
    resource: Arn,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails] =
      Optional.Absent,
    timeoutInSeconds: Optional[TimeoutInSeconds] = Optional.Absent,
    heartbeatInSeconds: Optional[TimeoutInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails = {
    import ActivityScheduledEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails
      .builder()
      .resource(Arn.unwrap(resource): java.lang.String)
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        timeoutInSeconds.map(value =>
          TimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        heartbeatInSeconds.map(value =>
          TimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.heartbeatInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly =
    zio.aws.sfn.model.ActivityScheduledEventDetails.wrap(buildAwsValue())
}
object ActivityScheduledEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ActivityScheduledEventDetails =
      zio.aws.sfn.model.ActivityScheduledEventDetails(
        resource,
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        timeoutInSeconds.map(value => value),
        heartbeatInSeconds.map(value => value)
      )
    def resource: Arn
    def input: Optional[SensitiveData]
    def inputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def timeoutInSeconds: Optional[TimeoutInSeconds]
    def heartbeatInSeconds: Optional[TimeoutInSeconds]
    def getResource: ZIO[Any, Nothing, Arn] = ZIO.succeed(resource)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getTimeoutInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getHeartbeatInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("heartbeatInSeconds", heartbeatInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails
  ) extends zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly {
    override val resource: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.resource())
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
    override val timeoutInSeconds: Optional[TimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value => zio.aws.sfn.model.primitives.TimeoutInSeconds(value))
    override val heartbeatInSeconds: Optional[TimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatInSeconds())
        .map(value => zio.aws.sfn.model.primitives.TimeoutInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ActivityScheduledEventDetails
  ): zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly = new Wrapper(
    impl
  )
}
