package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateActivityRequest(
    name: Name,
    tags: Optional[Iterable[zio.aws.sfn.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateActivityRequest = {
    import CreateActivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateActivityRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateActivityRequest.ReadOnly =
    zio.aws.sfn.model.CreateActivityRequest.wrap(buildAwsValue())
}
object CreateActivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateActivityRequest =
      zio.aws.sfn.model.CreateActivityRequest(
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sfn.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ) extends zio.aws.sfn.model.CreateActivityRequest.ReadOnly {
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sfn.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ): zio.aws.sfn.model.CreateActivityRequest.ReadOnly = new Wrapper(impl)
}
