package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteStateMachineRequest(stateMachineArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest = {
    import DeleteStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DeleteStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.DeleteStateMachineRequest.wrap(buildAwsValue())
}
object DeleteStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DeleteStateMachineRequest =
      zio.aws.sfn.model.DeleteStateMachineRequest(stateMachineArn)
    def stateMachineArn: Arn
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest
  ) extends zio.aws.sfn.model.DeleteStateMachineRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest
  ): zio.aws.sfn.model.DeleteStateMachineRequest.ReadOnly = new Wrapper(impl)
}
