package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeActivityRequest(activityArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeActivityRequest = {
    import DescribeActivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeActivityRequest
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeActivityRequest.ReadOnly =
    zio.aws.sfn.model.DescribeActivityRequest.wrap(buildAwsValue())
}
object DescribeActivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeActivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeActivityRequest =
      zio.aws.sfn.model.DescribeActivityRequest(activityArn)
    def activityArn: Arn
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityRequest
  ) extends zio.aws.sfn.model.DescribeActivityRequest.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityRequest
  ): zio.aws.sfn.model.DescribeActivityRequest.ReadOnly = new Wrapper(impl)
}
