package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeStateMachineForExecutionRequest(executionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest = {
    import DescribeStateMachineForExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.DescribeStateMachineForExecutionRequest.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineForExecutionRequest
      .wrap(buildAwsValue())
}
object DescribeStateMachineForExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineForExecutionRequest =
      zio.aws.sfn.model.DescribeStateMachineForExecutionRequest(executionArn)
    def executionArn: Arn
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest
  ) extends zio.aws.sfn.model.DescribeStateMachineForExecutionRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest
  ): zio.aws.sfn.model.DescribeStateMachineForExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
