package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, Definition, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeStateMachineForExecutionResponse(
    stateMachineArn: Arn,
    name: Name,
    definition: Definition,
    roleArn: Arn,
    updateDate: Timestamp,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse = {
    import DescribeStateMachineForExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .definition(Definition.unwrap(definition): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .updateDate(Timestamp.unwrap(updateDate): Instant)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineForExecutionResponse
      .wrap(buildAwsValue())
}
object DescribeStateMachineForExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineForExecutionResponse =
      zio.aws.sfn.model.DescribeStateMachineForExecutionResponse(
        stateMachineArn,
        name,
        definition,
        roleArn,
        updateDate,
        loggingConfiguration.map(value => value.asEditable),
        tracingConfiguration.map(value => value.asEditable)
      )
    def stateMachineArn: Arn
    def name: Name
    def definition: Definition
    def roleArn: Arn
    def updateDate: Timestamp
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getUpdateDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateDate)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse
  ) extends zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val roleArn: Arn = zio.aws.sfn.model.primitives.Arn(impl.roleArn())
    override val updateDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.updateDate())
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse
  ): zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
