package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveCause, SensitiveError}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionStartFailedEventDetails(
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails = {
    import LambdaFunctionStartFailedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails
      .builder()
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly =
    zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails
      .wrap(buildAwsValue())
}
object LambdaFunctionStartFailedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails =
      zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails(
        error.map(value => value),
        cause.map(value => value)
      )
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails
  ) extends zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly {
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.LambdaFunctionStartFailedEventDetails
  ): zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly =
    new Wrapper(impl)
}
