package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{ListExecutionsPageToken, PageSize, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExecutionsRequest(
    stateMachineArn: Arn,
    statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[ListExecutionsPageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListExecutionsRequest = {
    import ListExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value =>
          ListExecutionsPageToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListExecutionsRequest.ReadOnly =
    zio.aws.sfn.model.ListExecutionsRequest.wrap(buildAwsValue())
}
object ListExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListExecutionsRequest =
      zio.aws.sfn.model.ListExecutionsRequest(
        stateMachineArn,
        statusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def stateMachineArn: Arn
    def statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[ListExecutionsPageToken]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getStatusFilter: ZIO[Any, AwsError, zio.aws.sfn.model.ExecutionStatus] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ListExecutionsPageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ) extends zio.aws.sfn.model.ListExecutionsRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value => zio.aws.sfn.model.ExecutionStatus.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
    override val nextToken: Optional[ListExecutionsPageToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.sfn.model.primitives.ListExecutionsPageToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ): zio.aws.sfn.model.ListExecutionsRequest.ReadOnly = new Wrapper(impl)
}
