package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveCause, SensitiveError, TaskToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendTaskFailureRequest(
    taskToken: TaskToken,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest = {
    import SendTaskFailureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.SendTaskFailureRequest.ReadOnly =
    zio.aws.sfn.model.SendTaskFailureRequest.wrap(buildAwsValue())
}
object SendTaskFailureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.SendTaskFailureRequest =
      zio.aws.sfn.model.SendTaskFailureRequest(
        taskToken,
        error.map(value => value),
        cause.map(value => value)
      )
    def taskToken: TaskToken
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest
  ) extends zio.aws.sfn.model.SendTaskFailureRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.sfn.model.primitives.TaskToken(impl.taskToken())
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest
  ): zio.aws.sfn.model.SendTaskFailureRequest.ReadOnly = new Wrapper(impl)
}
