package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveCause, SensitiveError, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TaskTimedOutEventDetails(
    resourceType: Name,
    resource: Name,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails = {
    import TaskTimedOutEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails
      .builder()
      .resourceType(Name.unwrap(resourceType): java.lang.String)
      .resource(Name.unwrap(resource): java.lang.String)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly =
    zio.aws.sfn.model.TaskTimedOutEventDetails.wrap(buildAwsValue())
}
object TaskTimedOutEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TaskTimedOutEventDetails =
      zio.aws.sfn.model.TaskTimedOutEventDetails(
        resourceType,
        resource,
        error.map(value => value),
        cause.map(value => value)
      )
    def resourceType: Name
    def resource: Name
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def getResourceType: ZIO[Any, Nothing, Name] = ZIO.succeed(resourceType)
    def getResource: ZIO[Any, Nothing, Name] = ZIO.succeed(resource)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails
  ) extends zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly {
    override val resourceType: Name =
      zio.aws.sfn.model.primitives.Name(impl.resourceType())
    override val resource: Name =
      zio.aws.sfn.model.primitives.Name(impl.resource())
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TaskTimedOutEventDetails
  ): zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly = new Wrapper(impl)
}
