package zio.aws.sns
import zio.aws.sns.model.CreatePlatformEndpointResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.sns.model.{
  UnsubscribeRequest,
  GetTopicAttributesRequest,
  CheckIfPhoneNumberIsOptedOutRequest,
  DeleteEndpointRequest,
  ListPhoneNumbersOptedOutRequest,
  ListSmsSandboxPhoneNumbersRequest,
  SetEndpointAttributesRequest,
  ListSubscriptionsByTopicRequest,
  GetSmsSandboxAccountStatusRequest,
  CreateTopicRequest,
  OptInPhoneNumberRequest,
  ListTagsForResourceRequest,
  PublishRequest,
  CreatePlatformEndpointRequest,
  DeleteSmsSandboxPhoneNumberRequest,
  CreateSmsSandboxPhoneNumberRequest,
  SubscribeRequest,
  SetSubscriptionAttributesRequest,
  GetPlatformApplicationAttributesRequest,
  GetSubscriptionAttributesRequest,
  VerifySmsSandboxPhoneNumberRequest,
  ListOriginationNumbersRequest,
  ListTopicsRequest,
  ListSubscriptionsRequest,
  ConfirmSubscriptionRequest,
  ListPlatformApplicationsRequest,
  GetSmsAttributesRequest,
  UntagResourceRequest,
  DeletePlatformApplicationRequest,
  SetPlatformApplicationAttributesRequest,
  PublishBatchRequest,
  GetDataProtectionPolicyRequest,
  DeleteTopicRequest,
  ListEndpointsByPlatformApplicationRequest,
  CreatePlatformApplicationRequest,
  AddPermissionRequest,
  RemovePermissionRequest,
  TagResourceRequest,
  SetTopicAttributesRequest,
  SetSmsAttributesRequest,
  GetEndpointAttributesRequest,
  PutDataProtectionPolicyRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher
import software.amazon.awssdk.services.sns.model.{
  DeletePlatformApplicationResponse,
  DeleteTopicResponse,
  SetPlatformApplicationAttributesResponse,
  ListSubscriptionsByTopicResponse,
  ListSmsSandboxPhoneNumbersResponse,
  GetSubscriptionAttributesResponse,
  DeleteEndpointResponse,
  SetSmsAttributesResponse,
  PhoneNumberInformation,
  ConfirmSubscriptionResponse,
  ListTopicsResponse,
  SetSubscriptionAttributesResponse,
  CreatePlatformEndpointResponse,
  CreateSmsSandboxPhoneNumberResponse,
  OptInPhoneNumberResponse,
  SetEndpointAttributesResponse,
  RemovePermissionResponse,
  ListPlatformApplicationsResponse,
  Subscription,
  UnsubscribeResponse,
  GetSmsAttributesResponse,
  PublishResponse,
  SubscribeResponse,
  PublishBatchResponse,
  PlatformApplication,
  ListTagsForResourceResponse,
  ListEndpointsByPlatformApplicationResponse,
  UntagResourceResponse,
  CreateTopicResponse,
  GetTopicAttributesResponse,
  DeleteSmsSandboxPhoneNumberResponse,
  GetDataProtectionPolicyResponse,
  AddPermissionResponse,
  SetTopicAttributesResponse,
  VerifySmsSandboxPhoneNumberResponse,
  GetSmsSandboxAccountStatusResponse,
  ListOriginationNumbersResponse,
  Topic,
  Endpoint,
  CreatePlatformApplicationResponse,
  ListPhoneNumbersOptedOutResponse,
  PutDataProtectionPolicyResponse,
  GetPlatformApplicationAttributesResponse,
  TagResourceResponse,
  CheckIfPhoneNumberIsOptedOutResponse,
  GetEndpointAttributesResponse,
  SMSSandboxPhoneNumber,
  ListSubscriptionsResponse
}
import zio.aws.sns.model.primitives.PhoneNumber
import zio.stream.ZStream
import software.amazon.awssdk.services.sns.{
  SnsAsyncClientBuilder,
  SnsAsyncClient
}
import scala.jdk.CollectionConverters._
trait Sns extends AspectSupport[Sns] {
  val api: SnsAsyncClient
  def setSubscriptionAttributes(
      request: SetSubscriptionAttributesRequest
  ): IO[AwsError, Unit]
  def getEndpointAttributes(
      request: GetEndpointAttributesRequest
  ): IO[AwsError, zio.aws.sns.model.GetEndpointAttributesResponse.ReadOnly]
  def unsubscribe(request: UnsubscribeRequest): IO[AwsError, Unit]
  def createTopic(
      request: CreateTopicRequest
  ): IO[AwsError, zio.aws.sns.model.CreateTopicResponse.ReadOnly]
  def listSubscriptions(
      request: ListSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly]
  def listSubscriptionsPaginated(
      request: ListSubscriptionsRequest
  ): IO[AwsError, zio.aws.sns.model.ListSubscriptionsResponse.ReadOnly]
  def getSMSAttributes(
      request: GetSmsAttributesRequest
  ): IO[AwsError, zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly]
  def setPlatformApplicationAttributes(
      request: SetPlatformApplicationAttributesRequest
  ): IO[AwsError, Unit]
  def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit]
  def listPhoneNumbersOptedOut(
      request: ListPhoneNumbersOptedOutRequest
  ): ZStream[Any, AwsError, PhoneNumber]
  def listPhoneNumbersOptedOutPaginated(
      request: ListPhoneNumbersOptedOutRequest
  ): IO[AwsError, zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly]
  def optInPhoneNumber(
      request: OptInPhoneNumberRequest
  ): IO[AwsError, zio.aws.sns.model.OptInPhoneNumberResponse.ReadOnly]
  def setSMSAttributes(
      request: SetSmsAttributesRequest
  ): IO[AwsError, zio.aws.sns.model.SetSmsAttributesResponse.ReadOnly]
  def listSubscriptionsByTopic(
      request: ListSubscriptionsByTopicRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly]
  def listSubscriptionsByTopicPaginated(
      request: ListSubscriptionsByTopicRequest
  ): IO[AwsError, zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly]
  def getPlatformApplicationAttributes(
      request: GetPlatformApplicationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly
  ]
  def deletePlatformApplication(
      request: DeletePlatformApplicationRequest
  ): IO[AwsError, Unit]
  def addPermission(request: AddPermissionRequest): IO[AwsError, Unit]
  def setEndpointAttributes(
      request: SetEndpointAttributesRequest
  ): IO[AwsError, Unit]
  def checkIfPhoneNumberIsOptedOut(
      request: CheckIfPhoneNumberIsOptedOutRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.sns.model.UntagResourceResponse.ReadOnly]
  def createPlatformEndpoint(
      request: CreatePlatformEndpointRequest
  ): IO[AwsError, ReadOnly]
  def putDataProtectionPolicy(
      request: PutDataProtectionPolicyRequest
  ): IO[AwsError, Unit]
  def getDataProtectionPolicy(
      request: GetDataProtectionPolicyRequest
  ): IO[AwsError, zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly]
  def confirmSubscription(
      request: ConfirmSubscriptionRequest
  ): IO[AwsError, zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly]
  def createSMSSandboxPhoneNumber(
      request: CreateSmsSandboxPhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.ReadOnly
  ]
  def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit]
  def listSMSSandboxPhoneNumbers(
      request: ListSmsSandboxPhoneNumbersRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly]
  def listSMSSandboxPhoneNumbersPaginated(
      request: ListSmsSandboxPhoneNumbersRequest
  ): IO[AwsError, zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly]
  def deleteTopic(request: DeleteTopicRequest): IO[AwsError, Unit]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.sns.model.ListTagsForResourceResponse.ReadOnly]
  def listEndpointsByPlatformApplication(
      request: ListEndpointsByPlatformApplicationRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.Endpoint.ReadOnly]
  def listEndpointsByPlatformApplicationPaginated(
      request: ListEndpointsByPlatformApplicationRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.sns.model.TagResourceResponse.ReadOnly]
  def subscribe(
      request: SubscribeRequest
  ): IO[AwsError, zio.aws.sns.model.SubscribeResponse.ReadOnly]
  def deleteSMSSandboxPhoneNumber(
      request: DeleteSmsSandboxPhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.ReadOnly
  ]
  def setTopicAttributes(request: SetTopicAttributesRequest): IO[AwsError, Unit]
  def getTopicAttributes(
      request: GetTopicAttributesRequest
  ): IO[AwsError, zio.aws.sns.model.GetTopicAttributesResponse.ReadOnly]
  def publish(
      request: PublishRequest
  ): IO[AwsError, zio.aws.sns.model.PublishResponse.ReadOnly]
  def createPlatformApplication(
      request: CreatePlatformApplicationRequest
  ): IO[AwsError, zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly]
  def listPlatformApplications(
      request: ListPlatformApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.PlatformApplication.ReadOnly]
  def listPlatformApplicationsPaginated(
      request: ListPlatformApplicationsRequest
  ): IO[AwsError, zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly]
  def getSMSSandboxAccountStatus(
      request: GetSmsSandboxAccountStatusRequest
  ): IO[AwsError, zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.ReadOnly]
  def verifySMSSandboxPhoneNumber(
      request: VerifySmsSandboxPhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.ReadOnly
  ]
  def publishBatch(
      request: PublishBatchRequest
  ): IO[AwsError, zio.aws.sns.model.PublishBatchResponse.ReadOnly]
  def getSubscriptionAttributes(
      request: GetSubscriptionAttributesRequest
  ): IO[AwsError, zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly]
  def listOriginationNumbers(
      request: ListOriginationNumbersRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.PhoneNumberInformation.ReadOnly]
  def listOriginationNumbersPaginated(
      request: ListOriginationNumbersRequest
  ): IO[AwsError, zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly]
  def listTopics(
      request: ListTopicsRequest
  ): ZStream[Any, AwsError, zio.aws.sns.model.Topic.ReadOnly]
  def listTopicsPaginated(
      request: ListTopicsRequest
  ): IO[AwsError, zio.aws.sns.model.ListTopicsResponse.ReadOnly]
}
object Sns {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sns] = customized(identity)
  def customized(
      customization: SnsAsyncClientBuilder => SnsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sns] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SnsAsyncClientBuilder => SnsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sns] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SnsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SnsAsyncClient, SnsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SnsAsyncClient, SnsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SnsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SnsImpl[R](
      override val api: SnsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sns
      with AwsServiceBase[R] {
    override val serviceName: String = "Sns"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SnsImpl[R1] = new SnsImpl(api, newAspect, r)
    def setSubscriptionAttributes(
        request: SetSubscriptionAttributesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest,
      SetSubscriptionAttributesResponse
    ]("setSubscriptionAttributes", api.setSubscriptionAttributes)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getEndpointAttributes(
        request: GetEndpointAttributesRequest
    ): IO[AwsError, zio.aws.sns.model.GetEndpointAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest,
        GetEndpointAttributesResponse
      ]("getEndpointAttributes", api.getEndpointAttributes)(
        request.buildAwsValue()
      ).map(zio.aws.sns.model.GetEndpointAttributesResponse.wrap)
        .provideEnvironment(r)
    def unsubscribe(request: UnsubscribeRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.UnsubscribeRequest,
        UnsubscribeResponse
      ]("unsubscribe", api.unsubscribe)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createTopic(
        request: CreateTopicRequest
    ): IO[AwsError, zio.aws.sns.model.CreateTopicResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.CreateTopicRequest,
        CreateTopicResponse
      ]("createTopic", api.createTopic)(request.buildAwsValue())
        .map(zio.aws.sns.model.CreateTopicResponse.wrap)
        .provideEnvironment(r)
    def listSubscriptions(
        request: ListSubscriptionsRequest
    ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest,
        ListSubscriptionsResponse,
        Subscription
      ](
        "listSubscriptions",
        api.listSubscriptions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.subscriptions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sns.model.Subscription.wrap(item))
        .provideEnvironment(r)
    def listSubscriptionsPaginated(
        request: ListSubscriptionsRequest
    ): IO[AwsError, zio.aws.sns.model.ListSubscriptionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest,
        ListSubscriptionsResponse
      ]("listSubscriptions", api.listSubscriptions)(request.buildAwsValue())
        .map(zio.aws.sns.model.ListSubscriptionsResponse.wrap)
        .provideEnvironment(r)
    def getSMSAttributes(
        request: GetSmsAttributesRequest
    ): IO[AwsError, zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest,
        GetSmsAttributesResponse
      ]("getSMSAttributes", api.getSMSAttributes)(request.buildAwsValue())
        .map(zio.aws.sns.model.GetSmsAttributesResponse.wrap)
        .provideEnvironment(r)
    def setPlatformApplicationAttributes(
        request: SetPlatformApplicationAttributesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest,
      SetPlatformApplicationAttributesResponse
    ]("setPlatformApplicationAttributes", api.setPlatformApplicationAttributes)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.DeleteEndpointRequest,
        DeleteEndpointResponse
      ]("deleteEndpoint", api.deleteEndpoint)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listPhoneNumbersOptedOut(
        request: ListPhoneNumbersOptedOutRequest
    ): ZStream[Any, AwsError, PhoneNumber] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest,
      java.lang.String,
      ListPhoneNumbersOptedOutPublisher
    ](
      "listPhoneNumbersOptedOut",
      api.listPhoneNumbersOptedOutPaginator,
      _.phoneNumbers()
    )(request.buildAwsValue())
      .map(item => zio.aws.sns.model.primitives.PhoneNumber(item))
      .provideEnvironment(r)
    def listPhoneNumbersOptedOutPaginated(
        request: ListPhoneNumbersOptedOutRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest,
      ListPhoneNumbersOptedOutResponse
    ]("listPhoneNumbersOptedOut", api.listPhoneNumbersOptedOut)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.wrap)
      .provideEnvironment(r)
    def optInPhoneNumber(
        request: OptInPhoneNumberRequest
    ): IO[AwsError, zio.aws.sns.model.OptInPhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest,
        OptInPhoneNumberResponse
      ]("optInPhoneNumber", api.optInPhoneNumber)(request.buildAwsValue())
        .map(zio.aws.sns.model.OptInPhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def setSMSAttributes(
        request: SetSmsAttributesRequest
    ): IO[AwsError, zio.aws.sns.model.SetSmsAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest,
        SetSmsAttributesResponse
      ]("setSMSAttributes", api.setSMSAttributes)(request.buildAwsValue())
        .map(zio.aws.sns.model.SetSmsAttributesResponse.wrap)
        .provideEnvironment(r)
    def listSubscriptionsByTopic(
        request: ListSubscriptionsByTopicRequest
    ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest,
        ListSubscriptionsByTopicResponse,
        Subscription
      ](
        "listSubscriptionsByTopic",
        api.listSubscriptionsByTopic,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.subscriptions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sns.model.Subscription.wrap(item))
        .provideEnvironment(r)
    def listSubscriptionsByTopicPaginated(
        request: ListSubscriptionsByTopicRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest,
      ListSubscriptionsByTopicResponse
    ]("listSubscriptionsByTopic", api.listSubscriptionsByTopic)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.ListSubscriptionsByTopicResponse.wrap)
      .provideEnvironment(r)
    def getPlatformApplicationAttributes(
        request: GetPlatformApplicationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest,
      GetPlatformApplicationAttributesResponse
    ]("getPlatformApplicationAttributes", api.getPlatformApplicationAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.GetPlatformApplicationAttributesResponse.wrap)
      .provideEnvironment(r)
    def deletePlatformApplication(
        request: DeletePlatformApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest,
      DeletePlatformApplicationResponse
    ]("deletePlatformApplication", api.deletePlatformApplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def addPermission(request: AddPermissionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.AddPermissionRequest,
        AddPermissionResponse
      ]("addPermission", api.addPermission)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def setEndpointAttributes(
        request: SetEndpointAttributesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest,
      SetEndpointAttributesResponse
    ]("setEndpointAttributes", api.setEndpointAttributes)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def checkIfPhoneNumberIsOptedOut(
        request: CheckIfPhoneNumberIsOptedOutRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest,
      CheckIfPhoneNumberIsOptedOutResponse
    ]("checkIfPhoneNumberIsOptedOut", api.checkIfPhoneNumberIsOptedOut)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.sns.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.sns.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createPlatformEndpoint(
        request: CreatePlatformEndpointRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest,
      CreatePlatformEndpointResponse
    ]("createPlatformEndpoint", api.createPlatformEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.CreatePlatformEndpointResponse.wrap)
      .provideEnvironment(r)
    def putDataProtectionPolicy(
        request: PutDataProtectionPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest,
      PutDataProtectionPolicyResponse
    ]("putDataProtectionPolicy", api.putDataProtectionPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getDataProtectionPolicy(request: GetDataProtectionPolicyRequest): IO[
      AwsError,
      zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest,
      GetDataProtectionPolicyResponse
    ]("getDataProtectionPolicy", api.getDataProtectionPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.GetDataProtectionPolicyResponse.wrap)
      .provideEnvironment(r)
    def confirmSubscription(
        request: ConfirmSubscriptionRequest
    ): IO[AwsError, zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest,
        ConfirmSubscriptionResponse
      ]("confirmSubscription", api.confirmSubscription)(request.buildAwsValue())
        .map(zio.aws.sns.model.ConfirmSubscriptionResponse.wrap)
        .provideEnvironment(r)
    def createSMSSandboxPhoneNumber(
        request: CreateSmsSandboxPhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest,
      CreateSmsSandboxPhoneNumberResponse
    ]("createSMSSandboxPhoneNumber", api.createSMSSandboxPhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.RemovePermissionRequest,
        RemovePermissionResponse
      ]("removePermission", api.removePermission)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listSMSSandboxPhoneNumbers(
        request: ListSmsSandboxPhoneNumbersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest,
      ListSmsSandboxPhoneNumbersResponse,
      SMSSandboxPhoneNumber
    ](
      "listSMSSandboxPhoneNumbers",
      api.listSMSSandboxPhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sns.model.SMSSandboxPhoneNumber.wrap(item))
      .provideEnvironment(r)
    def listSMSSandboxPhoneNumbersPaginated(
        request: ListSmsSandboxPhoneNumbersRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest,
      ListSmsSandboxPhoneNumbersResponse
    ]("listSMSSandboxPhoneNumbers", api.listSMSSandboxPhoneNumbers)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def deleteTopic(request: DeleteTopicRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.DeleteTopicRequest,
        DeleteTopicResponse
      ]("deleteTopic", api.deleteTopic)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.sns.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.sns.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listEndpointsByPlatformApplication(
        request: ListEndpointsByPlatformApplicationRequest
    ): ZStream[Any, AwsError, zio.aws.sns.model.Endpoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest,
        ListEndpointsByPlatformApplicationResponse,
        Endpoint
      ](
        "listEndpointsByPlatformApplication",
        api.listEndpointsByPlatformApplication,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.endpoints().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sns.model.Endpoint.wrap(item))
        .provideEnvironment(r)
    def listEndpointsByPlatformApplicationPaginated(
        request: ListEndpointsByPlatformApplicationRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest,
      ListEndpointsByPlatformApplicationResponse
    ](
      "listEndpointsByPlatformApplication",
      api.listEndpointsByPlatformApplication
    )(request.buildAwsValue())
      .map(zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.sns.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.sns.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def subscribe(
        request: SubscribeRequest
    ): IO[AwsError, zio.aws.sns.model.SubscribeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.SubscribeRequest,
        SubscribeResponse
      ]("subscribe", api.subscribe)(request.buildAwsValue())
        .map(zio.aws.sns.model.SubscribeResponse.wrap)
        .provideEnvironment(r)
    def deleteSMSSandboxPhoneNumber(
        request: DeleteSmsSandboxPhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest,
      DeleteSmsSandboxPhoneNumberResponse
    ]("deleteSMSSandboxPhoneNumber", api.deleteSMSSandboxPhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def setTopicAttributes(
        request: SetTopicAttributesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest,
      SetTopicAttributesResponse
    ]("setTopicAttributes", api.setTopicAttributes)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getTopicAttributes(
        request: GetTopicAttributesRequest
    ): IO[AwsError, zio.aws.sns.model.GetTopicAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest,
        GetTopicAttributesResponse
      ]("getTopicAttributes", api.getTopicAttributes)(request.buildAwsValue())
        .map(zio.aws.sns.model.GetTopicAttributesResponse.wrap)
        .provideEnvironment(r)
    def publish(
        request: PublishRequest
    ): IO[AwsError, zio.aws.sns.model.PublishResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.PublishRequest,
        PublishResponse
      ]("publish", api.publish)(request.buildAwsValue())
        .map(zio.aws.sns.model.PublishResponse.wrap)
        .provideEnvironment(r)
    def createPlatformApplication(
        request: CreatePlatformApplicationRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest,
      CreatePlatformApplicationResponse
    ]("createPlatformApplication", api.createPlatformApplication)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.CreatePlatformApplicationResponse.wrap)
      .provideEnvironment(r)
    def listPlatformApplications(request: ListPlatformApplicationsRequest)
        : ZStream[
          Any,
          AwsError,
          zio.aws.sns.model.PlatformApplication.ReadOnly
        ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest,
      ListPlatformApplicationsResponse,
      PlatformApplication
    ](
      "listPlatformApplications",
      api.listPlatformApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.platformApplications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sns.model.PlatformApplication.wrap(item))
      .provideEnvironment(r)
    def listPlatformApplicationsPaginated(
        request: ListPlatformApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest,
      ListPlatformApplicationsResponse
    ]("listPlatformApplications", api.listPlatformApplications)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.ListPlatformApplicationsResponse.wrap)
      .provideEnvironment(r)
    def getSMSSandboxAccountStatus(
        request: GetSmsSandboxAccountStatusRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusRequest,
      GetSmsSandboxAccountStatusResponse
    ]("getSMSSandboxAccountStatus", api.getSMSSandboxAccountStatus)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.wrap)
      .provideEnvironment(r)
    def verifySMSSandboxPhoneNumber(
        request: VerifySmsSandboxPhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest,
      VerifySmsSandboxPhoneNumberResponse
    ]("verifySMSSandboxPhoneNumber", api.verifySMSSandboxPhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def publishBatch(
        request: PublishBatchRequest
    ): IO[AwsError, zio.aws.sns.model.PublishBatchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.PublishBatchRequest,
        PublishBatchResponse
      ]("publishBatch", api.publishBatch)(request.buildAwsValue())
        .map(zio.aws.sns.model.PublishBatchResponse.wrap)
        .provideEnvironment(r)
    def getSubscriptionAttributes(
        request: GetSubscriptionAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest,
      GetSubscriptionAttributesResponse
    ]("getSubscriptionAttributes", api.getSubscriptionAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sns.model.GetSubscriptionAttributesResponse.wrap)
      .provideEnvironment(r)
    def listOriginationNumbers(request: ListOriginationNumbersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sns.model.PhoneNumberInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest,
      ListOriginationNumbersResponse,
      PhoneNumberInformation
    ](
      "listOriginationNumbers",
      api.listOriginationNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sns.model.PhoneNumberInformation.wrap(item))
      .provideEnvironment(r)
    def listOriginationNumbersPaginated(
        request: ListOriginationNumbersRequest
    ): IO[AwsError, zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest,
        ListOriginationNumbersResponse
      ]("listOriginationNumbers", api.listOriginationNumbers)(
        request.buildAwsValue()
      ).map(zio.aws.sns.model.ListOriginationNumbersResponse.wrap)
        .provideEnvironment(r)
    def listTopics(
        request: ListTopicsRequest
    ): ZStream[Any, AwsError, zio.aws.sns.model.Topic.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sns.model.ListTopicsRequest,
        ListTopicsResponse,
        Topic
      ](
        "listTopics",
        api.listTopics,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.topics().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sns.model.Topic.wrap(item))
        .provideEnvironment(r)
    def listTopicsPaginated(
        request: ListTopicsRequest
    ): IO[AwsError, zio.aws.sns.model.ListTopicsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sns.model.ListTopicsRequest,
        ListTopicsResponse
      ]("listTopics", api.listTopics)(request.buildAwsValue())
        .map(zio.aws.sns.model.ListTopicsResponse.wrap)
        .provideEnvironment(r)
  }
  def setSubscriptionAttributes(
      request: SetSubscriptionAttributesRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setSubscriptionAttributes(request))
  def getEndpointAttributes(request: GetEndpointAttributesRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetEndpointAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEndpointAttributes(request))
  def unsubscribe(
      request: UnsubscribeRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.unsubscribe(request))
  def createTopic(request: CreateTopicRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.CreateTopicResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTopic(request))
  def listSubscriptions(request: ListSubscriptionsRequest): ZStream[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.Subscription.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptions(request))
  def listSubscriptionsPaginated(request: ListSubscriptionsRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscriptionsPaginated(request))
  def getSMSAttributes(request: GetSmsAttributesRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSMSAttributes(request))
  def setPlatformApplicationAttributes(
      request: SetPlatformApplicationAttributesRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setPlatformApplicationAttributes(request))
  def deleteEndpoint(
      request: DeleteEndpointRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def listPhoneNumbersOptedOut(
      request: ListPhoneNumbersOptedOutRequest
  ): ZStream[zio.aws.sns.Sns, AwsError, PhoneNumber] =
    ZStream.serviceWithStream(_.listPhoneNumbersOptedOut(request))
  def listPhoneNumbersOptedOutPaginated(
      request: ListPhoneNumbersOptedOutRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumbersOptedOutPaginated(request))
  def optInPhoneNumber(request: OptInPhoneNumberRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.OptInPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.optInPhoneNumber(request))
  def setSMSAttributes(request: SetSmsAttributesRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.SetSmsAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setSMSAttributes(request))
  def listSubscriptionsByTopic(
      request: ListSubscriptionsByTopicRequest
  ): ZStream[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.Subscription.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptionsByTopic(request))
  def listSubscriptionsByTopicPaginated(
      request: ListSubscriptionsByTopicRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscriptionsByTopicPaginated(request))
  def getPlatformApplicationAttributes(
      request: GetPlatformApplicationAttributesRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPlatformApplicationAttributes(request))
  def deletePlatformApplication(
      request: DeletePlatformApplicationRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePlatformApplication(request))
  def addPermission(
      request: AddPermissionRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addPermission(request))
  def setEndpointAttributes(
      request: SetEndpointAttributesRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setEndpointAttributes(request))
  def checkIfPhoneNumberIsOptedOut(
      request: CheckIfPhoneNumberIsOptedOutRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.checkIfPhoneNumberIsOptedOut(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createPlatformEndpoint(
      request: CreatePlatformEndpointRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createPlatformEndpoint(request))
  def putDataProtectionPolicy(
      request: PutDataProtectionPolicyRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putDataProtectionPolicy(request))
  def getDataProtectionPolicy(request: GetDataProtectionPolicyRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataProtectionPolicy(request))
  def confirmSubscription(request: ConfirmSubscriptionRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmSubscription(request))
  def createSMSSandboxPhoneNumber(
      request: CreateSmsSandboxPhoneNumberRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSMSSandboxPhoneNumber(request))
  def removePermission(
      request: RemovePermissionRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removePermission(request))
  def listSMSSandboxPhoneNumbers(
      request: ListSmsSandboxPhoneNumbersRequest
  ): ZStream[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly
  ] = ZStream.serviceWithStream(_.listSMSSandboxPhoneNumbers(request))
  def listSMSSandboxPhoneNumbersPaginated(
      request: ListSmsSandboxPhoneNumbersRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSMSSandboxPhoneNumbersPaginated(request))
  def deleteTopic(
      request: DeleteTopicRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTopic(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listEndpointsByPlatformApplication(
      request: ListEndpointsByPlatformApplicationRequest
  ): ZStream[zio.aws.sns.Sns, AwsError, zio.aws.sns.model.Endpoint.ReadOnly] =
    ZStream.serviceWithStream(_.listEndpointsByPlatformApplication(request))
  def listEndpointsByPlatformApplicationPaginated(
      request: ListEndpointsByPlatformApplicationRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointsByPlatformApplicationPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def subscribe(request: SubscribeRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.SubscribeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.subscribe(request))
  def deleteSMSSandboxPhoneNumber(
      request: DeleteSmsSandboxPhoneNumberRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSMSSandboxPhoneNumber(request))
  def setTopicAttributes(
      request: SetTopicAttributesRequest
  ): ZIO[zio.aws.sns.Sns, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setTopicAttributes(request))
  def getTopicAttributes(request: GetTopicAttributesRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetTopicAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTopicAttributes(request))
  def publish(request: PublishRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.PublishResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publish(request))
  def createPlatformApplication(request: CreatePlatformApplicationRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlatformApplication(request))
  def listPlatformApplications(
      request: ListPlatformApplicationsRequest
  ): ZStream[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.PlatformApplication.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlatformApplications(request))
  def listPlatformApplicationsPaginated(
      request: ListPlatformApplicationsRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlatformApplicationsPaginated(request))
  def getSMSSandboxAccountStatus(
      request: GetSmsSandboxAccountStatusRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSMSSandboxAccountStatus(request))
  def verifySMSSandboxPhoneNumber(
      request: VerifySmsSandboxPhoneNumberRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifySMSSandboxPhoneNumber(request))
  def publishBatch(request: PublishBatchRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.PublishBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishBatch(request))
  def getSubscriptionAttributes(request: GetSubscriptionAttributesRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriptionAttributes(request))
  def listOriginationNumbers(request: ListOriginationNumbersRequest): ZStream[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.PhoneNumberInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.listOriginationNumbers(request))
  def listOriginationNumbersPaginated(
      request: ListOriginationNumbersRequest
  ): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOriginationNumbersPaginated(request))
  def listTopics(
      request: ListTopicsRequest
  ): ZStream[zio.aws.sns.Sns, AwsError, zio.aws.sns.model.Topic.ReadOnly] =
    ZStream.serviceWithStream(_.listTopics(request))
  def listTopicsPaginated(request: ListTopicsRequest): ZIO[
    zio.aws.sns.Sns,
    AwsError,
    zio.aws.sns.model.ListTopicsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTopicsPaginated(request))
}
