package zio.aws.sns
import zio.aws.sns.model.CreatePlatformEndpointResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.sns.model.{
  UnsubscribeRequest,
  GetTopicAttributesRequest,
  CheckIfPhoneNumberIsOptedOutRequest,
  DeleteEndpointRequest,
  ListPhoneNumbersOptedOutRequest,
  ListSmsSandboxPhoneNumbersRequest,
  SetEndpointAttributesRequest,
  ListSubscriptionsByTopicRequest,
  GetSmsSandboxAccountStatusRequest,
  CreateTopicRequest,
  OptInPhoneNumberRequest,
  ListTagsForResourceRequest,
  PublishRequest,
  CreatePlatformEndpointRequest,
  DeleteSmsSandboxPhoneNumberRequest,
  CreateSmsSandboxPhoneNumberRequest,
  SubscribeRequest,
  SetSubscriptionAttributesRequest,
  GetPlatformApplicationAttributesRequest,
  GetSubscriptionAttributesRequest,
  VerifySmsSandboxPhoneNumberRequest,
  ListOriginationNumbersRequest,
  ListTopicsRequest,
  ListSubscriptionsRequest,
  ConfirmSubscriptionRequest,
  ListPlatformApplicationsRequest,
  GetSmsAttributesRequest,
  UntagResourceRequest,
  DeletePlatformApplicationRequest,
  SetPlatformApplicationAttributesRequest,
  PublishBatchRequest,
  GetDataProtectionPolicyRequest,
  DeleteTopicRequest,
  ListEndpointsByPlatformApplicationRequest,
  CreatePlatformApplicationRequest,
  AddPermissionRequest,
  RemovePermissionRequest,
  TagResourceRequest,
  SetTopicAttributesRequest,
  SetSmsAttributesRequest,
  GetEndpointAttributesRequest,
  PutDataProtectionPolicyRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sns.model.primitives.PhoneNumber
import zio.stream.ZStream
import software.amazon.awssdk.services.sns.SnsAsyncClient
object SnsMock extends Mock[Sns] {
  object SetSubscriptionAttributes
      extends Effect[SetSubscriptionAttributesRequest, AwsError, Unit]
  object GetEndpointAttributes
      extends Effect[
        GetEndpointAttributesRequest,
        AwsError,
        zio.aws.sns.model.GetEndpointAttributesResponse.ReadOnly
      ]
  object Unsubscribe extends Effect[UnsubscribeRequest, AwsError, Unit]
  object CreateTopic
      extends Effect[
        CreateTopicRequest,
        AwsError,
        zio.aws.sns.model.CreateTopicResponse.ReadOnly
      ]
  object ListSubscriptions
      extends Stream[
        ListSubscriptionsRequest,
        AwsError,
        zio.aws.sns.model.Subscription.ReadOnly
      ]
  object ListSubscriptionsPaginated
      extends Effect[
        ListSubscriptionsRequest,
        AwsError,
        zio.aws.sns.model.ListSubscriptionsResponse.ReadOnly
      ]
  object GetSMSAttributes
      extends Effect[
        GetSmsAttributesRequest,
        AwsError,
        zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly
      ]
  object SetPlatformApplicationAttributes
      extends Effect[SetPlatformApplicationAttributesRequest, AwsError, Unit]
  object DeleteEndpoint extends Effect[DeleteEndpointRequest, AwsError, Unit]
  object ListPhoneNumbersOptedOut
      extends Stream[ListPhoneNumbersOptedOutRequest, AwsError, PhoneNumber]
  object ListPhoneNumbersOptedOutPaginated
      extends Effect[
        ListPhoneNumbersOptedOutRequest,
        AwsError,
        zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly
      ]
  object OptInPhoneNumber
      extends Effect[
        OptInPhoneNumberRequest,
        AwsError,
        zio.aws.sns.model.OptInPhoneNumberResponse.ReadOnly
      ]
  object SetSMSAttributes
      extends Effect[
        SetSmsAttributesRequest,
        AwsError,
        zio.aws.sns.model.SetSmsAttributesResponse.ReadOnly
      ]
  object ListSubscriptionsByTopic
      extends Stream[
        ListSubscriptionsByTopicRequest,
        AwsError,
        zio.aws.sns.model.Subscription.ReadOnly
      ]
  object ListSubscriptionsByTopicPaginated
      extends Effect[
        ListSubscriptionsByTopicRequest,
        AwsError,
        zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly
      ]
  object GetPlatformApplicationAttributes
      extends Effect[
        GetPlatformApplicationAttributesRequest,
        AwsError,
        zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly
      ]
  object DeletePlatformApplication
      extends Effect[DeletePlatformApplicationRequest, AwsError, Unit]
  object AddPermission extends Effect[AddPermissionRequest, AwsError, Unit]
  object SetEndpointAttributes
      extends Effect[SetEndpointAttributesRequest, AwsError, Unit]
  object CheckIfPhoneNumberIsOptedOut
      extends Effect[
        CheckIfPhoneNumberIsOptedOutRequest,
        AwsError,
        zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.sns.model.UntagResourceResponse.ReadOnly
      ]
  object CreatePlatformEndpoint
      extends Effect[CreatePlatformEndpointRequest, AwsError, ReadOnly]
  object PutDataProtectionPolicy
      extends Effect[PutDataProtectionPolicyRequest, AwsError, Unit]
  object GetDataProtectionPolicy
      extends Effect[
        GetDataProtectionPolicyRequest,
        AwsError,
        zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly
      ]
  object ConfirmSubscription
      extends Effect[
        ConfirmSubscriptionRequest,
        AwsError,
        zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly
      ]
  object CreateSMSSandboxPhoneNumber
      extends Effect[
        CreateSmsSandboxPhoneNumberRequest,
        AwsError,
        zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.ReadOnly
      ]
  object RemovePermission
      extends Effect[RemovePermissionRequest, AwsError, Unit]
  object ListSMSSandboxPhoneNumbers
      extends Stream[
        ListSmsSandboxPhoneNumbersRequest,
        AwsError,
        zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly
      ]
  object ListSMSSandboxPhoneNumbersPaginated
      extends Effect[
        ListSmsSandboxPhoneNumbersRequest,
        AwsError,
        zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly
      ]
  object DeleteTopic extends Effect[DeleteTopicRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.sns.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListEndpointsByPlatformApplication
      extends Stream[
        ListEndpointsByPlatformApplicationRequest,
        AwsError,
        zio.aws.sns.model.Endpoint.ReadOnly
      ]
  object ListEndpointsByPlatformApplicationPaginated
      extends Effect[
        ListEndpointsByPlatformApplicationRequest,
        AwsError,
        zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.sns.model.TagResourceResponse.ReadOnly
      ]
  object Subscribe
      extends Effect[
        SubscribeRequest,
        AwsError,
        zio.aws.sns.model.SubscribeResponse.ReadOnly
      ]
  object DeleteSMSSandboxPhoneNumber
      extends Effect[
        DeleteSmsSandboxPhoneNumberRequest,
        AwsError,
        zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.ReadOnly
      ]
  object SetTopicAttributes
      extends Effect[SetTopicAttributesRequest, AwsError, Unit]
  object GetTopicAttributes
      extends Effect[
        GetTopicAttributesRequest,
        AwsError,
        zio.aws.sns.model.GetTopicAttributesResponse.ReadOnly
      ]
  object Publish
      extends Effect[
        PublishRequest,
        AwsError,
        zio.aws.sns.model.PublishResponse.ReadOnly
      ]
  object CreatePlatformApplication
      extends Effect[
        CreatePlatformApplicationRequest,
        AwsError,
        zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly
      ]
  object ListPlatformApplications
      extends Stream[
        ListPlatformApplicationsRequest,
        AwsError,
        zio.aws.sns.model.PlatformApplication.ReadOnly
      ]
  object ListPlatformApplicationsPaginated
      extends Effect[
        ListPlatformApplicationsRequest,
        AwsError,
        zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly
      ]
  object GetSMSSandboxAccountStatus
      extends Effect[
        GetSmsSandboxAccountStatusRequest,
        AwsError,
        zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.ReadOnly
      ]
  object VerifySMSSandboxPhoneNumber
      extends Effect[
        VerifySmsSandboxPhoneNumberRequest,
        AwsError,
        zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.ReadOnly
      ]
  object PublishBatch
      extends Effect[
        PublishBatchRequest,
        AwsError,
        zio.aws.sns.model.PublishBatchResponse.ReadOnly
      ]
  object GetSubscriptionAttributes
      extends Effect[
        GetSubscriptionAttributesRequest,
        AwsError,
        zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly
      ]
  object ListOriginationNumbers
      extends Stream[
        ListOriginationNumbersRequest,
        AwsError,
        zio.aws.sns.model.PhoneNumberInformation.ReadOnly
      ]
  object ListOriginationNumbersPaginated
      extends Effect[
        ListOriginationNumbersRequest,
        AwsError,
        zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly
      ]
  object ListTopics
      extends Stream[
        ListTopicsRequest,
        AwsError,
        zio.aws.sns.model.Topic.ReadOnly
      ]
  object ListTopicsPaginated
      extends Effect[
        ListTopicsRequest,
        AwsError,
        zio.aws.sns.model.ListTopicsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Sns] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sns] { rts =>
        zio.ZIO.succeed {
          new Sns {
            val api: SnsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sns = this
            def setSubscriptionAttributes(
                request: SetSubscriptionAttributesRequest
            ): IO[AwsError, Unit] = proxy(SetSubscriptionAttributes, request)
            def getEndpointAttributes(
                request: GetEndpointAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.GetEndpointAttributesResponse.ReadOnly
            ] = proxy(GetEndpointAttributes, request)
            def unsubscribe(request: UnsubscribeRequest): IO[AwsError, Unit] =
              proxy(Unsubscribe, request)
            def createTopic(
                request: CreateTopicRequest
            ): IO[AwsError, zio.aws.sns.model.CreateTopicResponse.ReadOnly] =
              proxy(CreateTopic, request)
            def listSubscriptions(
                request: ListSubscriptionsRequest
            ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListSubscriptions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listSubscriptionsPaginated(
                request: ListSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListSubscriptionsResponse.ReadOnly
            ] = proxy(ListSubscriptionsPaginated, request)
            def getSMSAttributes(request: GetSmsAttributesRequest): IO[
              AwsError,
              zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly
            ] = proxy(GetSMSAttributes, request)
            def setPlatformApplicationAttributes(
                request: SetPlatformApplicationAttributesRequest
            ): IO[AwsError, Unit] =
              proxy(SetPlatformApplicationAttributes, request)
            def deleteEndpoint(
                request: DeleteEndpointRequest
            ): IO[AwsError, Unit] = proxy(DeleteEndpoint, request)
            def listPhoneNumbersOptedOut(
                request: ListPhoneNumbersOptedOutRequest
            ): ZStream[Any, AwsError, PhoneNumber] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPhoneNumbersOptedOut, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPhoneNumbersOptedOutPaginated(
                request: ListPhoneNumbersOptedOutRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly
            ] = proxy(ListPhoneNumbersOptedOutPaginated, request)
            def optInPhoneNumber(request: OptInPhoneNumberRequest): IO[
              AwsError,
              zio.aws.sns.model.OptInPhoneNumberResponse.ReadOnly
            ] = proxy(OptInPhoneNumber, request)
            def setSMSAttributes(request: SetSmsAttributesRequest): IO[
              AwsError,
              zio.aws.sns.model.SetSmsAttributesResponse.ReadOnly
            ] = proxy(SetSMSAttributes, request)
            def listSubscriptionsByTopic(
                request: ListSubscriptionsByTopicRequest
            ): ZStream[Any, AwsError, zio.aws.sns.model.Subscription.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListSubscriptionsByTopic, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listSubscriptionsByTopicPaginated(
                request: ListSubscriptionsByTopicRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly
            ] = proxy(ListSubscriptionsByTopicPaginated, request)
            def getPlatformApplicationAttributes(
                request: GetPlatformApplicationAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly
            ] = proxy(GetPlatformApplicationAttributes, request)
            def deletePlatformApplication(
                request: DeletePlatformApplicationRequest
            ): IO[AwsError, Unit] = proxy(DeletePlatformApplication, request)
            def addPermission(
                request: AddPermissionRequest
            ): IO[AwsError, Unit] = proxy(AddPermission, request)
            def setEndpointAttributes(
                request: SetEndpointAttributesRequest
            ): IO[AwsError, Unit] = proxy(SetEndpointAttributes, request)
            def checkIfPhoneNumberIsOptedOut(
                request: CheckIfPhoneNumberIsOptedOutRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly
            ] = proxy(CheckIfPhoneNumberIsOptedOut, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.sns.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def createPlatformEndpoint(
                request: CreatePlatformEndpointRequest
            ): IO[AwsError, ReadOnly] = proxy(CreatePlatformEndpoint, request)
            def putDataProtectionPolicy(
                request: PutDataProtectionPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutDataProtectionPolicy, request)
            def getDataProtectionPolicy(
                request: GetDataProtectionPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly
            ] = proxy(GetDataProtectionPolicy, request)
            def confirmSubscription(request: ConfirmSubscriptionRequest): IO[
              AwsError,
              zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly
            ] = proxy(ConfirmSubscription, request)
            def createSMSSandboxPhoneNumber(
                request: CreateSmsSandboxPhoneNumberRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.CreateSmsSandboxPhoneNumberResponse.ReadOnly
            ] = proxy(CreateSMSSandboxPhoneNumber, request)
            def removePermission(
                request: RemovePermissionRequest
            ): IO[AwsError, Unit] = proxy(RemovePermission, request)
            def listSMSSandboxPhoneNumbers(
                request: ListSmsSandboxPhoneNumbersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSMSSandboxPhoneNumbers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSMSSandboxPhoneNumbersPaginated(
                request: ListSmsSandboxPhoneNumbersRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly
            ] = proxy(ListSMSSandboxPhoneNumbersPaginated, request)
            def deleteTopic(request: DeleteTopicRequest): IO[AwsError, Unit] =
              proxy(DeleteTopic, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.sns.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listEndpointsByPlatformApplication(
                request: ListEndpointsByPlatformApplicationRequest
            ): ZStream[Any, AwsError, zio.aws.sns.model.Endpoint.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListEndpointsByPlatformApplication, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listEndpointsByPlatformApplicationPaginated(
                request: ListEndpointsByPlatformApplicationRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly
            ] = proxy(ListEndpointsByPlatformApplicationPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.sns.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def subscribe(
                request: SubscribeRequest
            ): IO[AwsError, zio.aws.sns.model.SubscribeResponse.ReadOnly] =
              proxy(Subscribe, request)
            def deleteSMSSandboxPhoneNumber(
                request: DeleteSmsSandboxPhoneNumberRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.DeleteSmsSandboxPhoneNumberResponse.ReadOnly
            ] = proxy(DeleteSMSSandboxPhoneNumber, request)
            def setTopicAttributes(
                request: SetTopicAttributesRequest
            ): IO[AwsError, Unit] = proxy(SetTopicAttributes, request)
            def getTopicAttributes(request: GetTopicAttributesRequest): IO[
              AwsError,
              zio.aws.sns.model.GetTopicAttributesResponse.ReadOnly
            ] = proxy(GetTopicAttributes, request)
            def publish(
                request: PublishRequest
            ): IO[AwsError, zio.aws.sns.model.PublishResponse.ReadOnly] =
              proxy(Publish, request)
            def createPlatformApplication(
                request: CreatePlatformApplicationRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly
            ] = proxy(CreatePlatformApplication, request)
            def listPlatformApplications(
                request: ListPlatformApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sns.model.PlatformApplication.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPlatformApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPlatformApplicationsPaginated(
                request: ListPlatformApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly
            ] = proxy(ListPlatformApplicationsPaginated, request)
            def getSMSSandboxAccountStatus(
                request: GetSmsSandboxAccountStatusRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.GetSmsSandboxAccountStatusResponse.ReadOnly
            ] = proxy(GetSMSSandboxAccountStatus, request)
            def verifySMSSandboxPhoneNumber(
                request: VerifySmsSandboxPhoneNumberRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.VerifySmsSandboxPhoneNumberResponse.ReadOnly
            ] = proxy(VerifySMSSandboxPhoneNumber, request)
            def publishBatch(
                request: PublishBatchRequest
            ): IO[AwsError, zio.aws.sns.model.PublishBatchResponse.ReadOnly] =
              proxy(PublishBatch, request)
            def getSubscriptionAttributes(
                request: GetSubscriptionAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly
            ] = proxy(GetSubscriptionAttributes, request)
            def listOriginationNumbers(
                request: ListOriginationNumbersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sns.model.PhoneNumberInformation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOriginationNumbers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOriginationNumbersPaginated(
                request: ListOriginationNumbersRequest
            ): IO[
              AwsError,
              zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly
            ] = proxy(ListOriginationNumbersPaginated, request)
            def listTopics(
                request: ListTopicsRequest
            ): ZStream[Any, AwsError, zio.aws.sns.model.Topic.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTopics, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTopicsPaginated(
                request: ListTopicsRequest
            ): IO[AwsError, zio.aws.sns.model.ListTopicsResponse.ReadOnly] =
              proxy(ListTopicsPaginated, request)
          }
        }
      }
    }
  }
}
