package zio.aws.sns.model
import zio.aws.sns.model.primitives.{Action, Delegate, Label, TopicARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddPermissionRequest(
    topicArn: TopicARN,
    label: Label,
    awsAccountIds: Iterable[Delegate],
    actionNames: Iterable[Action]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.AddPermissionRequest = {
    import AddPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.AddPermissionRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .label(Label.unwrap(label): java.lang.String)
      .awsAccountIds(awsAccountIds.map { item =>
        Delegate.unwrap(item): java.lang.String
      }.asJavaCollection)
      .actionNames(actionNames.map { item =>
        Action.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.AddPermissionRequest.ReadOnly =
    zio.aws.sns.model.AddPermissionRequest.wrap(buildAwsValue())
}
object AddPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.AddPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.AddPermissionRequest = zio.aws.sns.model
      .AddPermissionRequest(topicArn, label, awsAccountIds, actionNames)
    def topicArn: TopicARN
    def label: Label
    def awsAccountIds: List[Delegate]
    def actionNames: List[Action]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getLabel: ZIO[Any, Nothing, Label] = ZIO.succeed(label)
    def getAwsAccountIds: ZIO[Any, Nothing, List[Delegate]] =
      ZIO.succeed(awsAccountIds)
    def getActionNames: ZIO[Any, Nothing, List[Action]] =
      ZIO.succeed(actionNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.AddPermissionRequest
  ) extends zio.aws.sns.model.AddPermissionRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val label: Label = zio.aws.sns.model.primitives.Label(impl.label())
    override val awsAccountIds: List[Delegate] = impl
      .awsAccountIds()
      .asScala
      .map { item =>
        zio.aws.sns.model.primitives.Delegate(item)
      }
      .toList
    override val actionNames: List[Action] = impl
      .actionNames()
      .asScala
      .map { item =>
        zio.aws.sns.model.primitives.Action(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.AddPermissionRequest
  ): zio.aws.sns.model.AddPermissionRequest.ReadOnly = new Wrapper(impl)
}
