package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchResultErrorEntry(
    id: String,
    code: String,
    message: Optional[String] = Optional.Absent,
    senderFault: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.BatchResultErrorEntry = {
    import BatchResultErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.BatchResultErrorEntry
      .builder()
      .id(id: java.lang.String)
      .code(code: java.lang.String)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .senderFault(senderFault: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.BatchResultErrorEntry.ReadOnly =
    zio.aws.sns.model.BatchResultErrorEntry.wrap(buildAwsValue())
}
object BatchResultErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.BatchResultErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.BatchResultErrorEntry = zio.aws.sns.model
      .BatchResultErrorEntry(id, code, message.map(value => value), senderFault)
    def id: String
    def code: String
    def message: Optional[String]
    def senderFault: Boolean
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getCode: ZIO[Any, Nothing, String] = ZIO.succeed(code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getSenderFault: ZIO[Any, Nothing, Boolean] = ZIO.succeed(senderFault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.BatchResultErrorEntry
  ) extends zio.aws.sns.model.BatchResultErrorEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val code: String = impl.code(): String
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val senderFault: Boolean = impl.senderFault(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.BatchResultErrorEntry
  ): zio.aws.sns.model.BatchResultErrorEntry.ReadOnly = new Wrapper(impl)
}
