package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CheckIfPhoneNumberIsOptedOutRequest(phoneNumber: PhoneNumber) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest = {
    import CheckIfPhoneNumberIsOptedOutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest
      .builder()
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest.ReadOnly =
    zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest.wrap(buildAwsValue())
}
object CheckIfPhoneNumberIsOptedOutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest =
      zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest(phoneNumber)
    def phoneNumber: PhoneNumber
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest
  ) extends zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest.ReadOnly {
    override val phoneNumber: PhoneNumber =
      zio.aws.sns.model.primitives.PhoneNumber(impl.phoneNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest
  ): zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutRequest.ReadOnly =
    new Wrapper(impl)
}
