package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CheckIfPhoneNumberIsOptedOutResponse(
    isOptedOut: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse = {
    import CheckIfPhoneNumberIsOptedOutResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse
      .builder()
      .optionallyWith(isOptedOut.map(value => value: java.lang.Boolean))(
        _.isOptedOut
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly =
    zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.wrap(buildAwsValue())
}
object CheckIfPhoneNumberIsOptedOutResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse =
      zio.aws.sns.model
        .CheckIfPhoneNumberIsOptedOutResponse(isOptedOut.map(value => value))
    def isOptedOut: Optional[Boolean]
    def getIsOptedOut: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOptedOut", isOptedOut)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse
  ) extends zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly {
    override val isOptedOut: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isOptedOut())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse
  ): zio.aws.sns.model.CheckIfPhoneNumberIsOptedOutResponse.ReadOnly =
    new Wrapper(impl)
}
