package zio.aws.sns.model
import zio.aws.sns.model.primitives.{AuthenticateOnUnsubscribe, Token, TopicARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfirmSubscriptionRequest(
    topicArn: TopicARN,
    token: Token,
    authenticateOnUnsubscribe: Optional[AuthenticateOnUnsubscribe] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest = {
    import ConfirmSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .token(Token.unwrap(token): java.lang.String)
      .optionallyWith(
        authenticateOnUnsubscribe.map(value =>
          AuthenticateOnUnsubscribe.unwrap(value): java.lang.String
        )
      )(_.authenticateOnUnsubscribe)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ConfirmSubscriptionRequest.ReadOnly =
    zio.aws.sns.model.ConfirmSubscriptionRequest.wrap(buildAwsValue())
}
object ConfirmSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ConfirmSubscriptionRequest =
      zio.aws.sns.model.ConfirmSubscriptionRequest(
        topicArn,
        token,
        authenticateOnUnsubscribe.map(value => value)
      )
    def topicArn: TopicARN
    def token: Token
    def authenticateOnUnsubscribe: Optional[AuthenticateOnUnsubscribe]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getToken: ZIO[Any, Nothing, Token] = ZIO.succeed(token)
    def getAuthenticateOnUnsubscribe
        : ZIO[Any, AwsError, AuthenticateOnUnsubscribe] = AwsError
      .unwrapOptionField("authenticateOnUnsubscribe", authenticateOnUnsubscribe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest
  ) extends zio.aws.sns.model.ConfirmSubscriptionRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val token: Token = zio.aws.sns.model.primitives.Token(impl.token())
    override val authenticateOnUnsubscribe
        : Optional[AuthenticateOnUnsubscribe] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticateOnUnsubscribe())
      .map(value =>
        zio.aws.sns.model.primitives.AuthenticateOnUnsubscribe(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest
  ): zio.aws.sns.model.ConfirmSubscriptionRequest.ReadOnly = new Wrapper(impl)
}
