package zio.aws.sns.model
import zio.aws.sns.model.primitives.SubscriptionARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfirmSubscriptionResponse(
    subscriptionArn: Optional[SubscriptionARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse = {
    import ConfirmSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse
      .builder()
      .optionallyWith(
        subscriptionArn.map(value =>
          SubscriptionARN.unwrap(value): java.lang.String
        )
      )(_.subscriptionArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly =
    zio.aws.sns.model.ConfirmSubscriptionResponse.wrap(buildAwsValue())
}
object ConfirmSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ConfirmSubscriptionResponse =
      zio.aws.sns.model
        .ConfirmSubscriptionResponse(subscriptionArn.map(value => value))
    def subscriptionArn: Optional[SubscriptionARN]
    def getSubscriptionArn: ZIO[Any, AwsError, SubscriptionARN] =
      AwsError.unwrapOptionField("subscriptionArn", subscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse
  ) extends zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly {
    override val subscriptionArn: Optional[SubscriptionARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionArn())
        .map(value => zio.aws.sns.model.primitives.SubscriptionARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse
  ): zio.aws.sns.model.ConfirmSubscriptionResponse.ReadOnly = new Wrapper(impl)
}
