package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreatePlatformApplicationRequest(
    name: String,
    platform: String,
    attributes: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest = {
    import CreatePlatformApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest
      .builder()
      .name(name: java.lang.String)
      .platform(platform: java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreatePlatformApplicationRequest.ReadOnly =
    zio.aws.sns.model.CreatePlatformApplicationRequest.wrap(buildAwsValue())
}
object CreatePlatformApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreatePlatformApplicationRequest =
      zio.aws.sns.model
        .CreatePlatformApplicationRequest(name, platform, attributes)
    def name: String
    def platform: String
    def attributes: Map[String, String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getPlatform: ZIO[Any, Nothing, String] = ZIO.succeed(platform)
    def getAttributes: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest
  ) extends zio.aws.sns.model.CreatePlatformApplicationRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val platform: String = impl.platform(): String
    override val attributes: Map[String, String] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest
  ): zio.aws.sns.model.CreatePlatformApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
