package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlatformApplicationResponse(
    platformApplicationArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse = {
    import CreatePlatformApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse
      .builder()
      .optionallyWith(
        platformApplicationArn.map(value => value: java.lang.String)
      )(_.platformApplicationArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly =
    zio.aws.sns.model.CreatePlatformApplicationResponse.wrap(buildAwsValue())
}
object CreatePlatformApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreatePlatformApplicationResponse =
      zio.aws.sns.model.CreatePlatformApplicationResponse(
        platformApplicationArn.map(value => value)
      )
    def platformApplicationArn: Optional[String]
    def getPlatformApplicationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("platformApplicationArn", platformApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse
  ) extends zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly {
    override val platformApplicationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformApplicationArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse
  ): zio.aws.sns.model.CreatePlatformApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
