package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlatformEndpointRequest(
    platformApplicationArn: String,
    token: String,
    customUserData: Optional[String] = Optional.Absent,
    attributes: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest = {
    import CreatePlatformEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest
      .builder()
      .platformApplicationArn(platformApplicationArn: java.lang.String)
      .token(token: java.lang.String)
      .optionallyWith(customUserData.map(value => value: java.lang.String))(
        _.customUserData
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreatePlatformEndpointRequest.ReadOnly =
    zio.aws.sns.model.CreatePlatformEndpointRequest.wrap(buildAwsValue())
}
object CreatePlatformEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreatePlatformEndpointRequest =
      zio.aws.sns.model.CreatePlatformEndpointRequest(
        platformApplicationArn,
        token,
        customUserData.map(value => value),
        attributes.map(value => value)
      )
    def platformApplicationArn: String
    def token: String
    def customUserData: Optional[String]
    def attributes: Optional[Map[String, String]]
    def getPlatformApplicationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(platformApplicationArn)
    def getToken: ZIO[Any, Nothing, String] = ZIO.succeed(token)
    def getCustomUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customUserData", customUserData)
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest
  ) extends zio.aws.sns.model.CreatePlatformEndpointRequest.ReadOnly {
    override val platformApplicationArn: String =
      impl.platformApplicationArn(): String
    override val token: String = impl.token(): String
    override val customUserData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customUserData())
      .map(value => value: String)
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest
  ): zio.aws.sns.model.CreatePlatformEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
