package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlatformEndpointResponse(
    endpointArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse = {
    import CreatePlatformEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse
      .builder()
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreatePlatformEndpointResponse.ReadOnly =
    zio.aws.sns.model.CreatePlatformEndpointResponse.wrap(buildAwsValue())
}
object CreatePlatformEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreatePlatformEndpointResponse =
      zio.aws.sns.model
        .CreatePlatformEndpointResponse(endpointArn.map(value => value))
    def endpointArn: Optional[String]
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse
  ) extends zio.aws.sns.model.CreatePlatformEndpointResponse.ReadOnly {
    override val endpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse
  ): zio.aws.sns.model.CreatePlatformEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
