package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumberString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSmsSandboxPhoneNumberRequest(
    phoneNumber: PhoneNumberString,
    languageCode: Optional[zio.aws.sns.model.LanguageCodeString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest = {
    import CreateSmsSandboxPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest
      .builder()
      .phoneNumber(PhoneNumberString.unwrap(phoneNumber): java.lang.String)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest.ReadOnly =
    zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest.wrap(buildAwsValue())
}
object CreateSmsSandboxPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest =
      zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest(
        phoneNumber,
        languageCode.map(value => value)
      )
    def phoneNumber: PhoneNumberString
    def languageCode: Optional[zio.aws.sns.model.LanguageCodeString]
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumberString] =
      ZIO.succeed(phoneNumber)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.sns.model.LanguageCodeString] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest
  ) extends zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest.ReadOnly {
    override val phoneNumber: PhoneNumberString =
      zio.aws.sns.model.primitives.PhoneNumberString(impl.phoneNumber())
    override val languageCode: Optional[zio.aws.sns.model.LanguageCodeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.sns.model.LanguageCodeString.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest
  ): zio.aws.sns.model.CreateSmsSandboxPhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
