package zio.aws.sns.model
import zio.aws.sns.model.primitives.{AttributeValue, AttributeName, TopicName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTopicRequest(
    name: TopicName,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sns.model.Tag]] = Optional.Absent,
    dataProtectionPolicy: Optional[AttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreateTopicRequest = {
    import CreateTopicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreateTopicRequest
      .builder()
      .name(TopicName.unwrap(name): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dataProtectionPolicy.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.dataProtectionPolicy)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreateTopicRequest.ReadOnly =
    zio.aws.sns.model.CreateTopicRequest.wrap(buildAwsValue())
}
object CreateTopicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreateTopicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreateTopicRequest =
      zio.aws.sns.model.CreateTopicRequest(
        name,
        attributes.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataProtectionPolicy.map(value => value)
      )
    def name: TopicName
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def tags: Optional[List[zio.aws.sns.model.Tag.ReadOnly]]
    def dataProtectionPolicy: Optional[AttributeValue]
    def getName: ZIO[Any, Nothing, TopicName] = ZIO.succeed(name)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sns.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataProtectionPolicy: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("dataProtectionPolicy", dataProtectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreateTopicRequest
  ) extends zio.aws.sns.model.CreateTopicRequest.ReadOnly {
    override val name: TopicName =
      zio.aws.sns.model.primitives.TopicName(impl.name())
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sns.model.primitives.AttributeName(
                key
              ) -> zio.aws.sns.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val tags: Optional[List[zio.aws.sns.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.Tag.wrap(item)
          }.toList
        )
    override val dataProtectionPolicy: Optional[AttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProtectionPolicy())
        .map(value => zio.aws.sns.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreateTopicRequest
  ): zio.aws.sns.model.CreateTopicRequest.ReadOnly = new Wrapper(impl)
}
