package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTopicResponse(
    topicArn: Optional[TopicARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.CreateTopicResponse = {
    import CreateTopicResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.CreateTopicResponse
      .builder()
      .optionallyWith(
        topicArn.map(value => TopicARN.unwrap(value): java.lang.String)
      )(_.topicArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.CreateTopicResponse.ReadOnly =
    zio.aws.sns.model.CreateTopicResponse.wrap(buildAwsValue())
}
object CreateTopicResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.CreateTopicResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.CreateTopicResponse =
      zio.aws.sns.model.CreateTopicResponse(topicArn.map(value => value))
    def topicArn: Optional[TopicARN]
    def getTopicArn: ZIO[Any, AwsError, TopicARN] =
      AwsError.unwrapOptionField("topicArn", topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.CreateTopicResponse
  ) extends zio.aws.sns.model.CreateTopicResponse.ReadOnly {
    override val topicArn: Optional[TopicARN] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.sns.model.primitives.TopicARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.CreateTopicResponse
  ): zio.aws.sns.model.CreateTopicResponse.ReadOnly = new Wrapper(impl)
}
