package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEndpointRequest(endpointArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.DeleteEndpointRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.sns.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.DeleteEndpointRequest =
      zio.aws.sns.model.DeleteEndpointRequest(endpointArn)
    def endpointArn: String
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.DeleteEndpointRequest
  ) extends zio.aws.sns.model.DeleteEndpointRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.DeleteEndpointRequest
  ): zio.aws.sns.model.DeleteEndpointRequest.ReadOnly = new Wrapper(impl)
}
