package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePlatformApplicationRequest(
    platformApplicationArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest = {
    import DeletePlatformApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest
      .builder()
      .platformApplicationArn(platformApplicationArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.DeletePlatformApplicationRequest.ReadOnly =
    zio.aws.sns.model.DeletePlatformApplicationRequest.wrap(buildAwsValue())
}
object DeletePlatformApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.DeletePlatformApplicationRequest =
      zio.aws.sns.model.DeletePlatformApplicationRequest(platformApplicationArn)
    def platformApplicationArn: String
    def getPlatformApplicationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(platformApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest
  ) extends zio.aws.sns.model.DeletePlatformApplicationRequest.ReadOnly {
    override val platformApplicationArn: String =
      impl.platformApplicationArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest
  ): zio.aws.sns.model.DeletePlatformApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
