package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumberString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSmsSandboxPhoneNumberRequest(
    phoneNumber: PhoneNumberString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest = {
    import DeleteSmsSandboxPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest
      .builder()
      .phoneNumber(PhoneNumberString.unwrap(phoneNumber): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest.ReadOnly =
    zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest.wrap(buildAwsValue())
}
object DeleteSmsSandboxPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest =
      zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest(phoneNumber)
    def phoneNumber: PhoneNumberString
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumberString] =
      ZIO.succeed(phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest
  ) extends zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest.ReadOnly {
    override val phoneNumber: PhoneNumberString =
      zio.aws.sns.model.primitives.PhoneNumberString(impl.phoneNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest
  ): zio.aws.sns.model.DeleteSmsSandboxPhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
