package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTopicRequest(topicArn: TopicARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.DeleteTopicRequest = {
    import DeleteTopicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.DeleteTopicRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.DeleteTopicRequest.ReadOnly =
    zio.aws.sns.model.DeleteTopicRequest.wrap(buildAwsValue())
}
object DeleteTopicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.DeleteTopicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.DeleteTopicRequest =
      zio.aws.sns.model.DeleteTopicRequest(topicArn)
    def topicArn: TopicARN
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.DeleteTopicRequest
  ) extends zio.aws.sns.model.DeleteTopicRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.DeleteTopicRequest
  ): zio.aws.sns.model.DeleteTopicRequest.ReadOnly = new Wrapper(impl)
}
