package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Endpoint(
    endpointArn: Optional[String] = Optional.Absent,
    attributes: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sns.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.Endpoint
      .builder()
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.Endpoint.ReadOnly =
    zio.aws.sns.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sns.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.Endpoint = zio.aws.sns.model
      .Endpoint(endpointArn.map(value => value), attributes.map(value => value))
    def endpointArn: Optional[String]
    def attributes: Optional[Map[String, String]]
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.Endpoint
  ) extends zio.aws.sns.model.Endpoint.ReadOnly {
    override val endpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => value: String)
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.Endpoint
  ): zio.aws.sns.model.Endpoint.ReadOnly = new Wrapper(impl)
}
